/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.advancement;

import com.google.common.base.Preconditions;
import java.time.Instant;
import java.util.Optional;
import javax.annotation.Nullable;
import org.spongepowered.api.advancement.AdvancementProgress;
import org.spongepowered.api.advancement.criteria.AdvancementCriterion;
import org.spongepowered.api.advancement.criteria.CriterionProgress;
import org.spongepowered.common.advancement.ImplementationBackedCriterionProgress;
import org.spongepowered.common.advancement.SpongeOperatorCriterion;

public abstract class SpongeOperatorCriterionProgress
implements ImplementationBackedCriterionProgress,
CriterionProgress {
    final AdvancementProgress progress;
    private final SpongeOperatorCriterion criterion;
    @Nullable
    private Optional<Instant> cachedAchievedState;

    SpongeOperatorCriterionProgress(AdvancementProgress progress, SpongeOperatorCriterion criterion) {
        this.progress = progress;
        this.criterion = criterion;
    }

    @Override
    public SpongeOperatorCriterion getCriterion() {
        return this.criterion;
    }

    @Override
    public Optional<Instant> get() {
        if (this.cachedAchievedState == null) {
            this.cachedAchievedState = this.get0();
        }
        return this.cachedAchievedState;
    }

    abstract Optional<Instant> get0();

    @Override
    public Instant grant() {
        Instant time = null;
        for (AdvancementCriterion criterion : this.criterion.getCriteria()) {
            Instant time1 = this.progress.get(criterion).get().grant();
            if (time != null && !time1.isAfter(time)) continue;
            time = time1;
        }
        Preconditions.checkNotNull(time);
        return time;
    }

    @Override
    public Optional<Instant> revoke() {
        Optional<Instant> previousState = this.get();
        for (AdvancementCriterion criterion : this.criterion.getCriteria()) {
            this.progress.get(criterion).get().revoke();
        }
        return previousState;
    }

    @Override
    public void invalidateAchievedState() {
        this.cachedAchievedState = null;
    }
}

