/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.command.args;

import java.util.List;
import javax.annotation.Nullable;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.ArgUtils;
import org.spongepowered.api.command.args.ArgumentParseException;
import org.spongepowered.api.command.args.CommandArgs;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.text.Text;

public abstract class CommandElement {
    @Nullable
    private final Text key;

    protected CommandElement(@Nullable Text key) {
        this.key = key;
    }

    @Nullable
    public Text getKey() {
        return this.key;
    }

    @Nullable
    public String getUntranslatedKey() {
        return ArgUtils.textToArgKey(this.key);
    }

    public void parse(CommandSource source, CommandArgs args, CommandContext context) throws ArgumentParseException {
        Object val = this.parseValue(source, args);
        String key = this.getUntranslatedKey();
        if (key != null && val != null) {
            if (val instanceof Iterable) {
                for (Object ent : (Iterable)val) {
                    context.putArg(key, ent);
                }
            } else {
                context.putArg(key, val);
            }
        }
    }

    @Nullable
    protected abstract Object parseValue(CommandSource var1, CommandArgs var2) throws ArgumentParseException;

    public abstract List<String> complete(CommandSource var1, CommandArgs var2, CommandContext var3);

    public Text getUsage(CommandSource src) {
        return this.getKey() == null ? Text.of() : Text.of("<", this.getKey(), ">");
    }
}

