/*
 * Decompiled with CFR 0.152.
 */
package me.hypherionmc.simplerpclib.configuration.objects;

import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import me.hypherionmc.nightconfig.core.conversion.Path;
import me.hypherionmc.nightconfig.core.conversion.SpecComment;
import me.hypherionmc.simplerpclib.configuration.objects.Dimension;
import me.hypherionmc.simplerpclib.configuration.objects.RPCButton;
import me.hypherionmc.simplerpclib.discordutils.RichPresenceBuilder;
import me.hypherionmc.simplerpclib.discordutils.RichPresenceCore;
import me.hypherionmc.simplerpclib.integrations.launchers.LauncherUtils;
import me.hypherionmc.simplerpclib.util.APIUtils;
import me.hypherionmc.simplerpclib.util.IRPCContainer;

public class SinglePlayerSection
implements IRPCContainer {
    @Path(value="enabled")
    @SpecComment(value="Enable/Disable the Single Player Event")
    public boolean enabled = true;
    @Path(value="description")
    @SpecComment(value="The first line of text under the app name")
    public String description = "Currently In %world%";
    @Path(value="state")
    @SpecComment(value="The second line of text under the app name")
    public String state = "Playing lonely mode";
    @Path(value="largeImageKey")
    @SpecComment(value="The Asset ID of the image to display as the large image")
    public String largeImageKey = "mclogonew";
    @Path(value="largeImageText")
    @SpecComment(value="The text that gets displayed when the large image is hovered")
    public String largeImageText = "It's Minecraft %mcver%, but modded";
    @Path(value="smallImageKey")
    @SpecComment(value="The Asset ID of the image to display as the small image")
    public String smallImageKey = "mclogo";
    @Path(value="smallImageText")
    @SpecComment(value="The text that gets displayed when the small image is hovered")
    public String smallImageText = "%mods% mods installed";
    @Path(value="buttons")
    @SpecComment(value="The buttons to display on Discord")
    public List<RPCButton> buttonsList = new ArrayList<RPCButton>();

    @Override
    public RichPresenceBuilder getPresence(RichPresenceCore core) {
        RichPresenceBuilder build = new RichPresenceBuilder().setDetails(core.getUtilHandler().parseVars(this.description)).setLargeImage(this.largeImageKey).setLargeImageText(core.getUtilHandler().parseVars(this.largeImageText)).setSmallImage(this.smallImageKey).setSmallImageText(core.getUtilHandler().parseVars(this.smallImageText)).setTimeStamp(OffsetDateTime.now()).setButtons(APIUtils.parseButtons(this.buttonsList, core.getUtilHandler())).setState(core.getUtilHandler().parseVars(this.state));
        build = LauncherUtils.getLauncherOverrides(build, core);
        if (core.getClientConfig().dimension_overrides.enabled) {
            RichPresenceBuilder finalBuild = build;
            Optional<Dimension> dimension = APIUtils.findDimension(core.getClientConfig().dimension_overrides.dimensions, core.getUtilHandler().getWorld());
            if (dimension.isPresent()) {
                Dimension dim = dimension.get();
                if (dim.description != null && !dim.description.isEmpty()) {
                    finalBuild.setDetails(core.getUtilHandler().parseVars(dim.description));
                }
                if (dim.state != null && !dim.state.isEmpty()) {
                    finalBuild.setState(core.getUtilHandler().parseVars(dim.state));
                }
                if (dim.largeImageKey != null && !dim.largeImageKey.isEmpty()) {
                    finalBuild.setLargeImage(dim.largeImageKey);
                }
                if (dim.largeImageText != null && !dim.largeImageText.isEmpty()) {
                    finalBuild.setLargeImageText(core.getUtilHandler().parseVars(dim.largeImageText));
                }
                if (dim.smallImageKey != null && !dim.smallImageKey.isEmpty()) {
                    finalBuild.setSmallImage(dim.smallImageKey);
                }
                if (dim.smallImageText != null && !dim.smallImageText.isEmpty()) {
                    finalBuild.setSmallImageText(core.getUtilHandler().parseVars(dim.smallImageText));
                }
                build = finalBuild;
            }
        }
        return this.enabled ? build : null;
    }
}

