/*
 * Decompiled with CFR 0.152.
 */
package com.carrot.carrotshop.listener;

import com.carrot.carrotshop.ShopsData;
import com.carrot.carrotshop.shop.Shop;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.block.BlockTypes;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.Order;
import org.spongepowered.api.event.block.ChangeBlockEvent;
import org.spongepowered.api.event.block.tileentity.ChangeSignEvent;
import org.spongepowered.api.util.Direction;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

public class BlockBreakListener {
    private boolean isSignAndShop(Location<World> loc, Direction dir, boolean wall) {
        if (loc.getRelative(dir).getBlockType() == (wall ? BlockTypes.WALL_SIGN : BlockTypes.STANDING_SIGN)) {
            Optional direction;
            Location sign;
            if (wall && (sign = loc.getRelative(dir)).supports(Keys.DIRECTION) && (direction = sign.get(Keys.DIRECTION)).isPresent() && direction.get() != dir) {
                return false;
            }
            Optional<List<Shop>> shops = ShopsData.getShops((Location<World>)loc.getRelative(dir));
            if (shops.isPresent()) {
                return true;
            }
        }
        return false;
    }

    @Listener(order=Order.FIRST, beforeModifications=true)
    public void onBlockBreak(ChangeBlockEvent.Break event) {
        for (Transaction transaction : event.getTransactions()) {
            Optional loc;
            if (!transaction.isValid() || !(loc = ((BlockSnapshot)transaction.getOriginal()).getLocation()).isPresent()) continue;
            Optional<List<Shop>> shops = ShopsData.getShops((Location<World>)((Location)loc.get()));
            if (shops.isPresent()) {
                Optional cause = event.getCause().first(Player.class);
                if (cause.isPresent()) {
                    ArrayList toDelete = new ArrayList();
                    shops.get().forEach(shop -> toDelete.add(shop));
                    toDelete.forEach(shop -> {
                        if (!shop.destroy((CommandSource)cause.get())) {
                            event.setCancelled(true);
                        }
                    });
                    continue;
                }
                event.setCancelled(true);
                continue;
            }
            if (!this.isSignAndShop((Location<World>)((Location)loc.get()), Direction.UP, false) && !this.isSignAndShop((Location<World>)((Location)loc.get()), Direction.NORTH, true) && !this.isSignAndShop((Location<World>)((Location)loc.get()), Direction.SOUTH, true) && !this.isSignAndShop((Location<World>)((Location)loc.get()), Direction.EAST, true) && !this.isSignAndShop((Location<World>)((Location)loc.get()), Direction.WEST, true)) continue;
            event.setCancelled(true);
        }
    }

    @Listener(order=Order.FIRST, beforeModifications=true)
    public void onSignChanged(ChangeSignEvent event) {
        Optional<List<Shop>> shops = ShopsData.getShops((Location<World>)event.getTargetTile().getLocation());
        if (shops.isPresent()) {
            event.setCancelled(true);
        }
    }
}

