/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.lib.configurate.objectmapping;

import com.google.common.reflect.Invokable;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import me.lucko.luckperms.lib.configurate.ConfigurationNode;
import me.lucko.luckperms.lib.configurate.commented.CommentedConfigurationNode;
import me.lucko.luckperms.lib.configurate.objectmapping.DefaultObjectMapperFactory;
import me.lucko.luckperms.lib.configurate.objectmapping.ObjectMappingException;
import me.lucko.luckperms.lib.configurate.objectmapping.Setting;
import me.lucko.luckperms.lib.configurate.objectmapping.serialize.TypeSerializer;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ObjectMapper<T> {
    private final TypeToken<T> type;
    private final Class<? super T> clazz;
    private final @Nullable Invokable<T, T> constructor;
    private final Map<String, FieldData> cachedFields = new LinkedHashMap<String, FieldData>();

    public static <T> ObjectMapper<T> forClass(@NonNull Class<T> clazz) throws ObjectMappingException {
        return DefaultObjectMapperFactory.getInstance().getMapper(clazz);
    }

    public static <T> ObjectMapper<T> forType(@NonNull TypeToken<T> type) throws ObjectMappingException {
        return DefaultObjectMapperFactory.getInstance().getMapper(type);
    }

    public static <T> BoundInstance forObject(@NonNull T obj) throws ObjectMappingException {
        return ObjectMapper.forClass(Objects.requireNonNull(obj).getClass()).bind(obj);
    }

    public static <T> BoundInstance forObject(TypeToken<T> type, @NonNull T obj) throws ObjectMappingException {
        return ObjectMapper.forType(Objects.requireNonNull(type)).bind(obj);
    }

    @Deprecated
    protected ObjectMapper(Class<T> type) throws ObjectMappingException {
        this(TypeToken.of(type));
    }

    @Deprecated
    protected boolean isLegacy() {
        if (this.getClass().getPackage() != ObjectMapper.class.getPackage()) {
            try {
                this.getClass().getDeclaredMethod("collectFields", Map.class, Class.class);
                return true;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return false;
    }

    protected ObjectMapper(TypeToken<T> type) throws ObjectMappingException {
        this.type = type;
        this.clazz = type.getRawType();
        if (this.clazz.isInterface()) {
            throw new ObjectMappingException("ObjectMapper can only work with concrete types");
        }
        Invokable constructor = null;
        try {
            constructor = type.constructor(type.getRawType().getDeclaredConstructor(new Class[0]));
            constructor.setAccessible(true);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        this.constructor = constructor;
        TypeToken collectType = type;
        Class collectClass = type.getRawType();
        boolean legacy = this.isLegacy();
        while (true) {
            if (legacy) {
                this.collectFields(this.cachedFields, collectClass);
            } else {
                this.collectFields(this.cachedFields, collectType);
            }
            collectClass = collectClass.getSuperclass();
            if (collectClass.equals(Object.class)) break;
            collectType = collectType.getSupertype(collectClass);
        }
    }

    @Deprecated
    protected void collectFields(Map<String, FieldData> cachedFields, Class<? super T> clazz) throws ObjectMappingException {
    }

    protected void collectFields(Map<String, FieldData> cachedFields, TypeToken<? super T> clazz) throws ObjectMappingException {
        for (Field field : clazz.getRawType().getDeclaredFields()) {
            if (!field.isAnnotationPresent(Setting.class)) continue;
            Setting setting = field.getAnnotation(Setting.class);
            String path = setting.value();
            if (path.isEmpty()) {
                path = field.getName();
            }
            TypeToken fieldType = clazz.resolveType(field.getGenericType());
            FieldData data = new FieldData(field, setting.comment(), fieldType);
            field.setAccessible(true);
            if (cachedFields.containsKey(path)) continue;
            cachedFields.put(path, data);
        }
    }

    protected T constructObject() throws ObjectMappingException {
        if (this.constructor == null) {
            throw new ObjectMappingException("No zero-arg constructor is available for class " + this.type + " but is required to construct new instances!");
        }
        try {
            return (T)this.constructor.invoke(null, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new ObjectMappingException("Unable to create instance of target class " + this.type, e);
        }
    }

    public boolean canCreateInstances() {
        return this.constructor != null;
    }

    public BoundInstance bind(T instance) {
        return new BoundInstance(instance);
    }

    public BoundInstance bindToNew() throws ObjectMappingException {
        return new BoundInstance(this.constructObject());
    }

    @Deprecated
    public Class<T> getMappedType() {
        return this.clazz;
    }

    public TypeToken<T> getType() {
        return this.type;
    }

    public class BoundInstance {
        private final T boundInstance;

        protected BoundInstance(T boundInstance) {
            this.boundInstance = boundInstance;
        }

        public T populate(ConfigurationNode source) throws ObjectMappingException {
            for (Map.Entry ent : ObjectMapper.this.cachedFields.entrySet()) {
                ConfigurationNode node = source.getNode(ent.getKey());
                ((FieldData)ent.getValue()).deserializeFrom(this.boundInstance, node);
            }
            return this.boundInstance;
        }

        public void serialize(ConfigurationNode target) throws ObjectMappingException {
            for (Map.Entry ent : ObjectMapper.this.cachedFields.entrySet()) {
                ConfigurationNode node = target.getNode(ent.getKey());
                ((FieldData)ent.getValue()).serializeTo(this.boundInstance, node);
            }
        }

        public T getInstance() {
            return this.boundInstance;
        }
    }

    protected static class FieldData {
        private final Field field;
        private final TypeToken<?> fieldType;
        private final String comment;

        public FieldData(Field field, String comment) throws ObjectMappingException {
            this(field, comment, TypeToken.of((Type)field.getGenericType()));
        }

        public FieldData(Field field, String comment, TypeToken<?> resolvedFieldType) {
            this.field = field;
            this.comment = comment;
            this.fieldType = resolvedFieldType;
        }

        public void deserializeFrom(Object instance, ConfigurationNode node) throws ObjectMappingException {
            TypeSerializer<?> serial = node.getOptions().getSerializers().get(this.fieldType);
            if (serial == null) {
                throw new ObjectMappingException("No TypeSerializer found for field " + this.field.getName() + " of type " + this.fieldType);
            }
            Object newVal = node.isVirtual() ? null : serial.deserialize(this.fieldType, node);
            try {
                if (newVal == null) {
                    Object existingVal = this.field.get(instance);
                    if (existingVal != null) {
                        this.serializeTo(instance, node);
                    }
                } else {
                    this.field.set(instance, newVal);
                }
            }
            catch (IllegalAccessException e) {
                throw new ObjectMappingException("Unable to deserialize field " + this.field.getName(), e);
            }
        }

        public void serializeTo(Object instance, ConfigurationNode node) throws ObjectMappingException {
            try {
                CommentedConfigurationNode commentNode;
                Object fieldVal = this.field.get(instance);
                if (fieldVal == null) {
                    node.setValue(null);
                } else {
                    TypeSerializer<?> serial = node.getOptions().getSerializers().get(this.fieldType);
                    if (serial == null) {
                        throw new ObjectMappingException("No TypeSerializer found for field " + this.field.getName() + " of type " + this.fieldType);
                    }
                    serial.serialize(this.fieldType, fieldVal, node);
                }
                if (node instanceof CommentedConfigurationNode && this.comment != null && !this.comment.isEmpty() && !(commentNode = (CommentedConfigurationNode)node).getComment().isPresent()) {
                    commentNode.setComment(this.comment);
                }
            }
            catch (IllegalAccessException e) {
                throw new ObjectMappingException("Unable to serialize field " + this.field.getName(), e);
            }
        }
    }
}

