/*
 * Decompiled with CFR 0.152.
 */
package gcewing.sg.client.gui;

import gcewing.sg.SGCraft;
import gcewing.sg.client.gui.SGScreen;
import gcewing.sg.container.SGBaseContainer;
import gcewing.sg.tileentity.SGBaseTE;
import gcewing.sg.util.SGAddressing;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class SGBaseScreen
extends SGScreen {
    static String screenTitle = "Stargate Address";
    static final int guiWidth = 256;
    int guiHeight = 208;
    static final int fuelGaugeWidth = 16;
    static final int fuelGaugeHeight = 34;
    static final int fuelGaugeX = 214;
    static final int fuelGaugeY = 84;
    static final int fuelGaugeU = 0;
    static final int fuelGaugeV = 208;
    private SGBaseTE te;
    private String address;
    private String formattedAddress;
    private boolean addressValid;
    private EntityPlayer player;

    public static SGBaseScreen create(EntityPlayer player, World world, BlockPos pos) {
        SGBaseTE te = SGBaseTE.at((IBlockAccess)world, pos);
        if (te != null) {
            return new SGBaseScreen(player, te);
        }
        return null;
    }

    private SGBaseScreen(EntityPlayer player, SGBaseTE te) {
        super(new SGBaseContainer(player, te), 256, 208);
        this.te = te;
        this.player = player;
        this.te.markBlockForUpdate();
        this.getAddress();
        if (this.addressValid && SGCraft.saveAddressToClipboard) {
            SGBaseScreen.func_146275_d((String)this.formattedAddress);
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    @Override
    protected void drawBackgroundLayer() {
        if (this.te.gateOrientation == 1 && this.te.allowAdminAccess(this.player.func_70005_c_())) {
            this.bindTexture(SGCraft.mod.resourceLocation("textures/gui/sg_gui.png"), 256, 256);
            this.guiHeight = 208;
        } else {
            this.guiHeight = 92;
            this.bindTexture(SGCraft.mod.resourceLocation("textures/gui/sg_gui_noinventory.png"), 256, 125);
        }
        this.drawTexturedRect(0.0, 0.0, 256.0, this.guiHeight, 0.0, 0.0);
        int cx = this.field_146999_f / 2;
        if (this.addressValid) {
            if (this.te.displayGateAddress) {
                this.drawAddressSymbols(cx, 22, this.address);
            } else {
                this.drawCenteredString("... Gate Address Hidden ...", cx, 42);
            }
        }
        this.setTextColor(19558);
        this.drawCenteredString(screenTitle, cx, 8);
        if (this.te.displayGateAddress) {
            this.drawCenteredString(this.formattedAddress, cx, 72);
        }
        if (SGBaseTE.numCamouflageSlots > 0 && this.te.gateOrientation == 1 && this.te.allowAdminAccess(this.player.func_70005_c_())) {
            this.drawCenteredString("Base Camouflage", 92, 92);
        }
    }

    private void getAddress() {
        if (this.te.homeAddress != null) {
            this.address = this.te.homeAddress;
            this.formattedAddress = SGAddressing.formatAddress(this.address, "-", "-");
            this.addressValid = true;
        } else {
            this.address = "";
            this.formattedAddress = this.te.addressError;
            this.addressValid = false;
        }
    }
}

