/*
 * Decompiled with CFR 0.152.
 */
package net.romvoid95.galactic.core.version;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import net.romvoid95.api.versioning.Version;
import net.romvoid95.galactic.core.GCTLog;
import net.romvoid95.galactic.core.version.VersionChecker;

public class ThreadVersionChecker
extends Thread {
    public ThreadVersionChecker() {
        this.setName("GalacticTweaks Version Check");
        this.setDaemon(true);
        this.start();
    }

    @Override
    public void run() {
        try {
            GCTLog.info("Starting GalacticTweaks Version Check Thread");
            VersionChecker.updateVersion = this.getLatestVersion();
            if (VersionChecker.updateVersion.isGreaterThan(VersionChecker.currentRunningVersion)) {
                VersionChecker.notifyForUpdate = true;
            }
            GCTLog.info("GalacticTweaks Version Check Finished");
        }
        catch (Exception e) {
            GCTLog.error("GalacticTweaks Version Check Failed", e);
            VersionChecker.checkThreadFailed = true;
        }
        if (!VersionChecker.checkThreadFailed) {
            if (VersionChecker.notifyForUpdate) {
                GCTLog.info("GalacticTweaks Update Found!");
            } else {
                GCTLog.info("GalacticTweaks is up to date");
            }
        }
        VersionChecker.checkThreadDone = true;
    }

    private Version getLatestVersion() {
        try {
            URL getRequestURL = new URL("https://addons-ecs.forgesvc.net/api/v2/addon/359766");
            HttpURLConnection con = (HttpURLConnection)getRequestURL.openConnection();
            con.setRequestMethod("GET");
            BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
            String response = "";
            String inputLine = in.readLine();
            if (inputLine != null) {
                response = response + inputLine;
                in.close();
                JsonParser parser = new JsonParser();
                JsonObject array = parser.parse(response).getAsJsonObject();
                JsonArray json = array.getAsJsonArray("latestFiles");
                JsonObject ob = json.get(0).getAsJsonObject();
                String version = ob.get("displayName").getAsString().split("-")[1].replace(".jar", "");
                return new Version(version);
            }
        }
        catch (Exception e) {
            GCTLog.error("There was an issue communicating with the CurseAPI", new Object[0]);
        }
        return null;
    }
}

