/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.zenscript.expression.partial;

import java.util.Arrays;
import java.util.HashMap;
import stanhebben.zenscript.compiler.EnvironmentClass;
import stanhebben.zenscript.compiler.IEnvironmentGlobal;
import stanhebben.zenscript.compiler.IEnvironmentMethod;
import stanhebben.zenscript.expression.Expression;
import stanhebben.zenscript.expression.ExpressionInvalid;
import stanhebben.zenscript.expression.partial.IPartialExpression;
import stanhebben.zenscript.symbols.IZenSymbol;
import stanhebben.zenscript.symbols.SymbolScriptReference;
import stanhebben.zenscript.type.ZenType;
import stanhebben.zenscript.util.ZenPosition;

public class PartialScriptReference
implements IPartialExpression {
    private final HashMap<String, PartialScriptReference> subs = new HashMap();
    private EnvironmentClass environmentScript = null;

    public void addScriptOrDirectory(EnvironmentClass environmentScript, String[] names) {
        if (names.length == 0) {
            this.environmentScript = environmentScript;
            return;
        }
        String name = names[0];
        this.subs.putIfAbsent(name, new PartialScriptReference());
        this.subs.get(name).addScriptOrDirectory(environmentScript, Arrays.copyOfRange(names, 1, names.length));
    }

    @Override
    public Expression eval(IEnvironmentGlobal environment) {
        throw new UnsupportedOperationException("Cannot eval a script file!");
    }

    @Override
    public Expression assign(ZenPosition position, IEnvironmentGlobal environment, Expression other) {
        throw new UnsupportedOperationException("Cannot assign to a script file!");
    }

    @Override
    public IPartialExpression getMember(ZenPosition position, IEnvironmentGlobal environment, String name) {
        IPartialExpression out = this.subs.get(name);
        if (out == null && this.environmentScript != null) {
            out = this.environmentScript.getValue(name, position);
        }
        if (out != null) {
            return out;
        }
        environment.error(position, "Could not get Reference: " + name);
        return new ExpressionInvalid(position);
    }

    @Override
    public Expression call(ZenPosition position, IEnvironmentMethod environment, Expression ... values) {
        throw new UnsupportedOperationException("Cannot call a script file!");
    }

    @Override
    public ZenType[] predictCallTypes(int numArguments) {
        return new ZenType[0];
    }

    @Override
    public IZenSymbol toSymbol() {
        return new SymbolScriptReference(this);
    }

    @Override
    public ZenType getType() {
        throw new UnsupportedOperationException("Cannot get a script file's type since it has no type!");
    }

    @Override
    public ZenType toType(IEnvironmentGlobal environment) {
        throw new UnsupportedOperationException("Cannot cast a script file!");
    }
}

