/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.renderer.animation.transformation;

import net.malisis.core.util.EnumFacingUtils;
import net.minecraft.util.EnumFacing;

public interface ITransformable {

    public static interface Size<T>
    extends ITransformable {
        public T setSize(int var1, int var2);
    }

    public static interface Position<T>
    extends ITransformable {
        public T setPosition(int var1, int var2);
    }

    public static interface Brightness
    extends ITransformable {
        public void setBrightness(int var1);
    }

    public static interface Alpha
    extends ITransformable {
        public void setAlpha(int var1);
    }

    public static interface Color
    extends ITransformable {
        public void setColor(int var1);
    }

    public static interface Scale
    extends ITransformable {
        public void scale(float var1, float var2, float var3, float var4, float var5, float var6);
    }

    public static interface Rotate
    extends ITransformable {
        public void rotate(float var1, float var2, float var3, float var4, float var5, float var6, float var7);

        default public void rotate(EnumFacing direction) {
            if (direction == EnumFacing.SOUTH) {
                return;
            }
            this.rotate(90 * EnumFacingUtils.getRotationCount(direction), 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        }
    }

    public static interface Translate
    extends ITransformable {
        public void translate(float var1, float var2, float var3);
    }
}

