/*
 * Decompiled with CFR 0.152.
 */
package com.universeguard.event.flags;

import com.flowpowered.math.vector.Vector3i;
import com.universeguard.region.Region;
import com.universeguard.region.enums.EnumRegionFlag;
import com.universeguard.utils.DirectionUtils;
import com.universeguard.utils.RegionUtils;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.util.Direction;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

public class FlagEnterListener
implements Runnable {
    @Override
    public void run() {
        for (Player player : Sponge.getServer().getOnlinePlayers()) {
            Region region = RegionUtils.getRegion((Location<World>)player.getLocation());
            Direction direction = DirectionUtils.getPlayerDirection(player);
            if (region == null || !region.isLocal() || RegionUtils.hasPermission(player, region) || region.getFlag(EnumRegionFlag.ENTER)) continue;
            player.setLocation(player.getLocation().sub(FlagEnterListener.getOffset(direction)));
        }
    }

    private static Vector3i getOffset(Direction direction) {
        int offsetX = 0;
        int offsetY = 0;
        int offsetZ = 0;
        if (direction.equals((Object)Direction.NORTH)) {
            offsetZ = -1;
        } else if (direction.equals((Object)Direction.SOUTH)) {
            offsetZ = 1;
        } else if (direction.equals((Object)Direction.EAST)) {
            offsetX = 1;
        } else if (direction.equals((Object)Direction.WEST)) {
            offsetX = -1;
        } else if (direction.equals((Object)Direction.UP)) {
            offsetY = -1;
        } else if (direction.equals((Object)Direction.DOWN)) {
            offsetY = 1;
        }
        return new Vector3i(offsetX, offsetY, offsetZ);
    }
}

