/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.services.impl.storage.dataaccess;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.List;
import java.util.Map;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.ValueType;

public class ConfigurationNodeJsonTranslator {
    public static ConfigurationNodeJsonTranslator INSTANCE = new ConfigurationNodeJsonTranslator();

    private ConfigurationNodeJsonTranslator() {
    }

    public ConfigurationNode from(ConfigurationNode nodeToPopulate, JsonObject object) {
        this.parseObject(object, nodeToPopulate);
        return nodeToPopulate;
    }

    public JsonObject jsonFrom(ConfigurationNode node) {
        JsonObject object = new JsonObject();
        if (!node.hasMapChildren()) {
            return object;
        }
        for (Map.Entry entry : node.getChildrenMap().entrySet()) {
            ConfigurationNode value = (ConfigurationNode)entry.getValue();
            if (value.isVirtual()) continue;
            String key = String.valueOf(entry.getKey());
            JsonElement element = this.fromNode(value);
            if (element == null) continue;
            object.add(key, element);
        }
        return object;
    }

    private JsonElement fromNode(ConfigurationNode value) {
        JsonObject element = null;
        if (value.getValueType() == ValueType.MAP) {
            element = this.jsonFrom(value);
        } else if (value.getValueType() == ValueType.LIST) {
            element = this.jsonFromList(value.getChildrenList());
        } else if (value.getValueType() == ValueType.SCALAR) {
            element = this.jsonFromScalar(value.getValue());
        }
        return element;
    }

    private JsonPrimitive jsonFromScalar(Object value) {
        JsonPrimitive primitive = value instanceof Number ? new JsonPrimitive((Number)value) : (value instanceof Boolean ? new JsonPrimitive((Boolean)value) : new JsonPrimitive(value.toString()));
        return primitive;
    }

    private JsonArray jsonFromList(List<? extends ConfigurationNode> listNode) {
        return listNode.stream().map(this::fromNode).collect(JsonArray::new, JsonArray::add, JsonArray::addAll);
    }

    private void parseArray(JsonArray array, ConfigurationNode node) {
        for (JsonElement element : array) {
            if (element.isJsonNull()) continue;
            this.parseElement(element, node.getAppendedNode());
        }
    }

    private void parseObject(JsonObject object, ConfigurationNode node) {
        for (Map.Entry entry : object.entrySet()) {
            JsonElement element = (JsonElement)entry.getValue();
            this.parseElement(element, node.getNode(new Object[]{entry.getKey()}));
        }
    }

    private void parsePrimitive(JsonPrimitive primitive, ConfigurationNode node) {
        if (primitive.isBoolean()) {
            node.setValue((Object)primitive.getAsBoolean());
        } else if (primitive.isString()) {
            node.setValue((Object)primitive.getAsString());
        } else if (primitive.isNumber()) {
            long l;
            double d = primitive.getAsDouble();
            if (d == (double)(l = primitive.getAsLong())) {
                int i = primitive.getAsInt();
                if ((long)i == l) {
                    node.setValue((Object)i);
                } else {
                    node.setValue((Object)l);
                }
            } else {
                node.setValue((Object)d);
            }
        }
    }

    private void parseElement(JsonElement element, ConfigurationNode node) {
        if (element.isJsonObject()) {
            this.from(node, element.getAsJsonObject());
        } else if (element.isJsonArray()) {
            this.parseArray(element.getAsJsonArray(), node);
        } else if (element.isJsonPrimitive()) {
            this.parsePrimitive(element.getAsJsonPrimitive(), node);
        }
    }
}

