/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.scaffold.command;

import io.github.nucleuspowered.nucleus.services.interfaces.IMessageProviderService;
import javax.annotation.Nullable;
import org.spongepowered.api.command.args.ArgumentParseException;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;

public class NucleusArgumentParseException
extends ArgumentParseException {
    private final IMessageProviderService messageProviderService;
    @Nullable
    private final Text subcommands;
    @Nullable
    private final Text usage;
    private final boolean isEnd;

    public static NucleusArgumentParseException from(IMessageProviderService messageProviderService, ArgumentParseException exception, @Nullable Text usage, @Nullable Text subcommands) {
        return new NucleusArgumentParseException(messageProviderService, Text.of((Object[])new Object[]{TextColors.RED, exception.getMessage()}), "", exception.getPosition(), usage, subcommands, exception instanceof NucleusArgumentParseException && ((NucleusArgumentParseException)exception).isEnd());
    }

    public NucleusArgumentParseException(IMessageProviderService messageProviderService, Text message, String source, int position, @Nullable Text usage, @Nullable Text subcommands, boolean isEnd) {
        super(message, source, position);
        this.messageProviderService = messageProviderService;
        this.usage = usage;
        this.subcommands = subcommands;
        this.isEnd = isEnd;
    }

    public Text getText() {
        Text t = super.getText();
        if (this.usage == null && this.subcommands == null) {
            return t;
        }
        return Text.join((Text[])new Text[]{t, Text.NEW_LINE, this.getUsage()});
    }

    @Nullable
    public Text getUsage() {
        Text.Builder builder = Text.builder();
        if (this.usage != null) {
            builder.append(new Text[]{Text.NEW_LINE}).append(new Text[]{this.messageProviderService.getMessage("command.exception.usage", this.usage)});
        }
        if (this.subcommands != null) {
            builder.append(new Text[]{Text.NEW_LINE}).append(new Text[]{this.messageProviderService.getMessage("command.exception.subcommands", this.subcommands)});
        }
        return builder.build();
    }

    public boolean shouldIncludeUsage() {
        return false;
    }

    public boolean isEnd() {
        return this.isEnd;
    }
}

