/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.note.commands;

import io.github.nucleuspowered.nucleus.Util;
import io.github.nucleuspowered.nucleus.modules.note.data.NoteData;
import io.github.nucleuspowered.nucleus.modules.note.services.NoteHandler;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.NucleusParameters;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import io.github.nucleuspowered.nucleus.services.interfaces.IMessageProviderService;
import java.time.Instant;
import java.util.UUID;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.text.channel.MutableMessageChannel;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@NonnullByDefault
@Command(aliases={"note", "addnote"}, basePermission={"nucleus.note.notify"}, commandDescriptionKey="note", associatedPermissions={"nucleus.note.notify", "nucleus.note.showonlogin"})
public class NoteCommand
implements ICommandExecutor<CommandSource> {
    @Override
    public CommandElement[] parameters(INucleusServiceCollection serviceCollection) {
        return new CommandElement[]{NucleusParameters.ONE_USER.get(serviceCollection), NucleusParameters.MESSAGE};
    }

    @Override
    public ICommandResult execute(ICommandContext<? extends CommandSource> context) throws CommandException {
        User user = context.requireOne("user", User.class);
        String note = context.requireOne("message", String.class);
        UUID noter = context.getUniqueId().orElse(Util.CONSOLE_FAKE_UUID);
        NoteData noteData = new NoteData(Instant.now(), noter, note);
        if (context.getServiceCollection().getServiceUnchecked(NoteHandler.class).addNote(user, noteData)) {
            MutableMessageChannel messageChannel = context.getServiceCollection().permissionService().permissionMessageChannel("nucleus.note.notify").asMutable();
            messageChannel.addMember((MessageReceiver)context.getCommandSource());
            IMessageProviderService messageProviderService = context.getServiceCollection().messageProvider();
            messageChannel.getMembers().forEach(messageReceiver -> messageProviderService.sendMessageTo((MessageReceiver)messageReceiver, "command.note.success", (Object)context.getName(), (Object)noteData.getNote(), (Object)user.getName()));
            return context.successResult();
        }
        context.sendMessage("command.warn.fail", user.getName());
        return context.successResult();
    }
}

