/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.mute.commands;

import io.github.nucleuspowered.nucleus.modules.mute.services.MuteHandler;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.NucleusParameters;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import java.util.UUID;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.text.channel.MutableMessageChannel;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@NonnullByDefault
@Command(aliases={"voice"}, basePermission={"nucleus.globalmute.voice.base"}, commandDescriptionKey="voice")
public class VoiceCommand
implements ICommandExecutor<CommandSource> {
    @Override
    public CommandElement[] parameters(INucleusServiceCollection serviceCollection) {
        return new CommandElement[]{NucleusParameters.ONE_PLAYER.get(serviceCollection), NucleusParameters.OPTIONAL_ONE_TRUE_FALSE};
    }

    @Override
    public ICommandResult execute(ICommandContext<? extends CommandSource> context) throws CommandException {
        UUID voice;
        MuteHandler muteHandler = context.getServiceCollection().getServiceUnchecked(MuteHandler.class);
        if (!muteHandler.isGlobalMuteEnabled()) {
            return context.errorResult("command.voice.globaloff", new Object[0]);
        }
        Player pl = context.requireOne("player", Player.class);
        if (context.testPermissionFor((Subject)pl, "nucleus.globalmute.voice.auto")) {
            return context.errorResult("command.voice.autovoice", pl.getName());
        }
        boolean turnOn = context.getOne("true|false", Boolean.class).orElseGet(() -> !muteHandler.isVoiced(pl.getUniqueId()));
        if (turnOn == muteHandler.isVoiced(voice = pl.getUniqueId())) {
            if (turnOn) {
                context.sendMessage("command.voice.alreadyvoiced", pl.getName());
            } else {
                context.sendMessage("command.voice.alreadynotvoiced", pl.getName());
            }
            return context.failResult();
        }
        MutableMessageChannel mmc = context.getServiceCollection().permissionService().permissionMessageChannel("nucleus.globalmute.voice.notify").asMutable();
        mmc.addMember((MessageReceiver)context.getCommandSource());
        if (turnOn) {
            muteHandler.addVoice(pl.getUniqueId());
            mmc.send(context.getMessage("command.voice.voiced.source", pl.getName()));
            context.sendMessageTo((MessageReceiver)pl, "command.voice.voiced.target", new Object[0]);
        } else {
            muteHandler.removeVoice(pl.getUniqueId());
            mmc.send(context.getMessage("command.voice.voiced.source", pl.getName()));
            context.sendMessageTo((MessageReceiver)pl, "command.voice.voiced.target", new Object[0]);
        }
        return context.successResult();
    }
}

