/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.message.commands;

import io.github.nucleuspowered.nucleus.api.EventContexts;
import io.github.nucleuspowered.nucleus.api.util.NoExceptionAutoClosable;
import io.github.nucleuspowered.nucleus.modules.message.HelpOpMessageChannel;
import io.github.nucleuspowered.nucleus.modules.message.config.MessageConfig;
import io.github.nucleuspowered.nucleus.modules.message.events.InternalNucleusHelpOpEvent;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.NucleusParameters;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.CommandModifier;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.EssentialsEquivalent;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import io.github.nucleuspowered.nucleus.services.interfaces.IChatMessageFormatterService;
import io.github.nucleuspowered.nucleus.services.interfaces.IReloadableService;
import javax.inject.Inject;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.event.message.MessageChannelEvent;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@EssentialsEquivalent(value={"helpop", "amsg", "ac"})
@NonnullByDefault
@Command(aliases={"helpop"}, basePermission={"nucleus.helpop.base"}, commandDescriptionKey="helpop", modifiers={@CommandModifier(value="nucleus:has_cooldown", exemptPermission="nucleus.helpop.exempt.cooldown"), @CommandModifier(value="nucleus:has_warmup", exemptPermission="nucleus.helpop.exempt.warmup"), @CommandModifier(value="nucleus:has_cost", exemptPermission="nucleus.helpop.exempt.cost")}, associatedPermissions={"nucleus.helpop.receive"})
public class HelpOpCommand
implements ICommandExecutor<Player>,
IReloadableService.Reloadable {
    private final IChatMessageFormatterService chatMessageFormatterService;
    private @Nullable HelpOpMessageChannel channel;

    @Inject
    public HelpOpCommand(INucleusServiceCollection serviceCollection) {
        this.chatMessageFormatterService = serviceCollection.chatMessageFormatter();
    }

    @Override
    public CommandElement[] parameters(INucleusServiceCollection serviceCollection) {
        return new CommandElement[]{NucleusParameters.MESSAGE};
    }

    @Override
    public ICommandResult execute(ICommandContext<? extends Player> context) throws CommandException {
        MessageChannelEvent.Chat chat;
        String message = context.requireOne("message", String.class);
        if (Sponge.getEventManager().post((Event)new InternalNucleusHelpOpEvent((CommandSource)context.getCommandSource(), message))) {
            return context.errorResult("message.cancel", new Object[0]);
        }
        Player player = context.getIfPlayer();
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();
             NoExceptionAutoClosable c = this.chatMessageFormatterService.setPlayerNucleusChannelTemporarily(player.getUniqueId(), this.channel);){
            frame.addContext(EventContexts.SHOULD_FORMAT_CHANNEL, (Object)false);
            frame.pushCause((Object)player);
            chat = player.simulateChat((Text)Text.of((String)message), Sponge.getCauseStackManager().getCurrentCause());
        }
        if (chat.isCancelled()) {
            context.sendMessage("command.helpop.fail", new Object[0]);
        } else {
            context.sendMessage("command.helpop.success", new Object[0]);
        }
        return context.successResult();
    }

    @Override
    public void onReload(INucleusServiceCollection serviceCollection) {
        this.channel = new HelpOpMessageChannel(serviceCollection.moduleDataProvider().getModuleConfig(MessageConfig.class).getHelpOpPrefix(serviceCollection.textTemplateFactory()), serviceCollection.permissionService(), serviceCollection.textStyleService());
    }
}

