/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.kit.commands;

import io.github.nucleuspowered.nucleus.api.module.kit.data.Kit;
import io.github.nucleuspowered.nucleus.modules.kit.commands.KitCommand;
import io.github.nucleuspowered.nucleus.modules.kit.services.KitService;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@Command(aliases={"cost", "setcost"}, basePermission={"nucleus.kit.cost.base"}, commandDescriptionKey="kit.cost", parentCommand=KitCommand.class, async=true)
@NonnullByDefault
public class KitCostCommand
implements ICommandExecutor<CommandSource> {
    private final String costKey = "cost";

    @Override
    public CommandElement[] parameters(INucleusServiceCollection serviceCollection) {
        return new CommandElement[]{serviceCollection.getServiceUnchecked(KitService.class).createKitElement(false), GenericArguments.onlyOne((CommandElement)GenericArguments.doubleNum((Text)Text.of((String)this.costKey)))};
    }

    @Override
    public ICommandResult execute(ICommandContext<? extends CommandSource> context) throws CommandException {
        Kit kit = context.requireOne("kit", Kit.class);
        double cost = context.requireOne(this.costKey, Double.class);
        if (cost < 0.0) {
            cost = 0.0;
        }
        kit.setCost(cost);
        context.getServiceCollection().getServiceUnchecked(KitService.class).saveKit(kit);
        context.sendMessage("command.kit.cost.success", kit.getName(), String.valueOf(cost));
        return context.successResult();
    }
}

