/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.freezeplayer.commands;

import io.github.nucleuspowered.nucleus.modules.freezeplayer.services.FreezePlayerService;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.NucleusParameters;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.CommandModifier;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@NonnullByDefault
@Command(aliases={"freezeplayer", "freeze"}, basePermission={"nucleus.freezeplayer.base"}, commandDescriptionKey="freezeplayer", async=true, modifiers={@CommandModifier(value="nucleus:has_cooldown", exemptPermission="nucleus.freezeplayer.exempt.cooldown"), @CommandModifier(value="nucleus:has_warmup", exemptPermission="nucleus.freezeplayer.exempt.warmup"), @CommandModifier(value="nucleus:has_cost", exemptPermission="nucleus.freezeplayer.exempt.cost")}, associatedPermissions={"nucleus.freezeplayer.others"})
public class FreezePlayerCommand
implements ICommandExecutor<CommandSource> {
    @Override
    public CommandElement[] parameters(INucleusServiceCollection serviceCollection) {
        return new CommandElement[]{serviceCollection.commandElementSupplier().createOtherUserPermissionElement(false, "nucleus.freezeplayer.others"), GenericArguments.optional((CommandElement)NucleusParameters.ONE_TRUE_FALSE)};
    }

    @Override
    public ICommandResult execute(ICommandContext<? extends CommandSource> context) throws CommandException {
        User pl = context.getUserFromArgs();
        FreezePlayerService service = context.getServiceCollection().getServiceUnchecked(FreezePlayerService.class);
        boolean f = context.getOne("true|false", Boolean.class).orElseGet(() -> !service.isFrozen(pl));
        service.setFrozen(pl, f);
        context.sendMessage(f ? "command.freezeplayer.success.frozen" : "command.freezeplayer.success.unfrozen", context.getServiceCollection().playerDisplayNameService().getDisplayName(pl));
        return context.successResult();
    }
}

