/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.core.commands.nucleus;

import io.github.nucleuspowered.nucleus.modules.core.commands.NucleusCommand;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import io.github.nucleuspowered.nucleus.services.interfaces.IPermissionService;
import io.github.nucleuspowered.nucleus.services.interfaces.data.SuggestedLevel;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@NonnullByDefault
@Command(aliases={"printperms"}, basePermission={"nucleus.nucleus.printperms.base"}, commandDescriptionKey="nucleus.printperms", parentCommand=NucleusCommand.class)
public class PrintPermsCommand
implements ICommandExecutor<CommandSource> {
    private static List<String> onStream(List<IPermissionService.Metadata> metadata, SuggestedLevel suggestedLevel) {
        return metadata.stream().filter(x -> x.getSuggestedLevel() == suggestedLevel).map(IPermissionService.Metadata::getPermission).collect(Collectors.toList());
    }

    @Override
    public ICommandResult execute(ICommandContext<? extends CommandSource> context) throws CommandException {
        List<IPermissionService.Metadata> l = context.getServiceCollection().permissionService().getAllMetadata();
        List<String> notsuggested = PrintPermsCommand.onStream(l, SuggestedLevel.NONE);
        List<String> owner = PrintPermsCommand.onStream(l, SuggestedLevel.OWNER);
        List<String> admin = PrintPermsCommand.onStream(l, SuggestedLevel.ADMIN);
        List<String> mod = PrintPermsCommand.onStream(l, SuggestedLevel.MOD);
        List<String> user = PrintPermsCommand.onStream(l, SuggestedLevel.USER);
        String file = "plugin-perms.txt";
        try (BufferedWriter f = new BufferedWriter(new FileWriter(file));){
            Consumer<String> permWriter = x -> {
                try {
                    f.write((String)x);
                    f.newLine();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            };
            f.write("Not Suggested");
            f.write("-----");
            f.newLine();
            notsuggested.stream().sorted().forEach(permWriter);
            f.newLine();
            f.write("Owner");
            f.write("-----");
            f.newLine();
            owner.stream().sorted().forEach(permWriter);
            f.newLine();
            f.write("Admin");
            f.write("-----");
            f.newLine();
            admin.stream().sorted().forEach(permWriter);
            f.newLine();
            f.write("Mod");
            f.write("-----");
            f.newLine();
            mod.stream().sorted().forEach(permWriter);
            f.newLine();
            f.write("User");
            f.write("-----");
            f.newLine();
            user.stream().sorted().forEach(permWriter);
            f.flush();
        }
        catch (IOException e) {
            throw new CommandException((Text)Text.of((String)"File write failed"), (Throwable)e);
        }
        context.sendMessage("command.printperms", file);
        return context.successResult();
    }
}

