/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.back.commands;

import io.github.nucleuspowered.nucleus.api.teleport.data.TeleportResult;
import io.github.nucleuspowered.nucleus.api.teleport.data.TeleportScanners;
import io.github.nucleuspowered.nucleus.modules.back.config.BackConfig;
import io.github.nucleuspowered.nucleus.modules.back.services.BackHandler;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.CommandModifier;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.EssentialsEquivalent;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import io.github.nucleuspowered.nucleus.services.interfaces.INucleusTeleportService;
import io.github.nucleuspowered.nucleus.services.interfaces.IReloadableService;
import java.util.Optional;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.entity.Transform;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.api.world.World;

@EssentialsEquivalent(value={"back", "return"})
@Command(aliases={"back", "return"}, basePermission={"nucleus.back.base"}, commandDescriptionKey="back", modifiers={@CommandModifier(value="nucleus:has_warmup", exemptPermission="nucleus.back.exempt.warmup"), @CommandModifier(value="nucleus:has_cooldown", exemptPermission="nucleus.back.exempt.cooldown"), @CommandModifier(value="nucleus:has_cost", exemptPermission="nucleus.back.exempt.cost")}, associatedPermissions={"nucleus.back.exempt.bordercheck", "nucleus.back.exempt.samedimension"})
@NonnullByDefault
public class BackCommand
implements ICommandExecutor<Player>,
IReloadableService.Reloadable {
    private boolean sameDimensionCheck = false;

    @Override
    public CommandElement[] parameters(INucleusServiceCollection serviceCollection) {
        return new CommandElement[]{GenericArguments.flags().permissionFlag("nucleus.back.exempt.bordercheck", new String[]{"b", "-border"}).flag(new String[]{"f", "-force"}).buildWith(GenericArguments.none())};
    }

    @Override
    public ICommandResult execute(ICommandContext<? extends Player> context) throws CommandException {
        Player src;
        BackHandler handler = context.getServiceCollection().getServiceUnchecked(BackHandler.class);
        Optional<Transform<World>> ol = handler.getLastLocation((User)(src = context.getIfPlayer()));
        if (!ol.isPresent()) {
            return context.errorResult("command.back.noloc", new Object[0]);
        }
        boolean border = context.hasAny("b");
        Transform<World> loc = ol.get();
        if (this.sameDimensionCheck && src.getWorld().getUniqueId() != ((World)loc.getExtent()).getUniqueId() && !context.testPermission("nucleus.back.exempt.samedimension")) {
            return context.errorResult("command.back.sameworld", new Object[0]);
        }
        INucleusTeleportService service = context.getServiceCollection().teleportService();
        try (INucleusTeleportService.BorderDisableSession ac = service.temporarilyDisableBorder(border, (World)loc.getExtent());){
            TeleportResult result = service.teleportPlayerSmart(src, loc, false, !context.hasAny("f"), TeleportScanners.NO_SCAN.get());
            if (result.isSuccessful()) {
                context.sendMessage("command.back.success", new Object[0]);
                ICommandResult iCommandResult = context.successResult();
                return iCommandResult;
            }
            if (result == TeleportResult.FAIL_NO_LOCATION) {
                ICommandResult iCommandResult = context.errorResult("command.back.nosafe", new Object[0]);
                return iCommandResult;
            }
            ICommandResult iCommandResult = context.errorResult("command.back.cancelled", new Object[0]);
            return iCommandResult;
        }
    }

    @Override
    public void onReload(INucleusServiceCollection serviceCollection) {
        this.sameDimensionCheck = serviceCollection.moduleDataProvider().getModuleConfig(BackConfig.class).isOnlySameDimension();
    }
}

