/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.configurate.typeserialisers;

import com.google.common.reflect.TypeToken;
import io.github.nucleuspowered.nucleus.api.module.warp.data.Warp;
import io.github.nucleuspowered.nucleus.configurate.typeserialisers.NamedLocationSerialiser;
import io.github.nucleuspowered.nucleus.modules.warp.data.WarpData;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.objectmapping.ObjectMappingException;
import ninja.leaping.configurate.objectmapping.serialize.TypeSerializer;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.serializer.TextSerializers;

public class WarpSerialiser
implements TypeSerializer<Warp> {
    private final Logger logger;

    public WarpSerialiser(Logger logger) {
        this.logger = logger;
    }

    public @Nullable Warp deserialize(@NonNull TypeToken<?> type, @NonNull ConfigurationNode value) throws ObjectMappingException {
        String desc = value.getNode(new Object[]{"description"}).getString();
        Text res = null;
        if (desc != null) {
            try {
                res = TextSerializers.JSON.deserialize(desc);
            }
            catch (RuntimeException ex) {
                this.logger.error("Could not deserialise description for warp {}, skipping description...", value.getKey(), (Object)ex);
            }
        }
        return new WarpData(value.getNode(new Object[]{"category"}).getString(), value.getNode(new Object[]{"cost"}).getDouble(0.0), res, NamedLocationSerialiser.getWorldUUID(value), NamedLocationSerialiser.getPosition(value), NamedLocationSerialiser.getRotation(value), NamedLocationSerialiser.getName(value));
    }

    public void serialize(@NonNull TypeToken<?> type, @Nullable Warp obj, @NonNull ConfigurationNode value) throws ObjectMappingException {
        if (obj == null) {
            return;
        }
        NamedLocationSerialiser.serializeLocation(obj, value);
        obj.getCategory().ifPresent(x -> value.getNode(new Object[]{"category"}).setValue(x));
        obj.getCost().ifPresent(x -> value.getNode(new Object[]{"cost"}).setValue(x));
    }
}

