/*
 * Decompiled with CFR 0.152.
 */
package wanion.lib.network;

import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import wanion.lib.WanionLib;
import wanion.lib.common.INameAcceptorContainer;

public class NameTransferMessage
implements IMessage {
    private int windowId;
    private String name;

    public NameTransferMessage() {
    }

    public NameTransferMessage(int windowId, String name) {
        this.windowId = windowId;
        this.name = name;
    }

    public void fromBytes(ByteBuf buf) {
        this.windowId = ByteBufUtils.readVarInt((ByteBuf)buf, (int)5);
        this.name = ByteBufUtils.readUTF8String((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeVarInt((ByteBuf)buf, (int)this.windowId, (int)5);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.name);
    }

    @SideOnly(value=Side.CLIENT)
    public static void sendToServer(@Nonnull Container container, String name) {
        WanionLib.networkWrapper.sendToServer((IMessage)new NameTransferMessage(container.field_75152_c, name));
    }

    public static class Handler
    implements IMessageHandler<NameTransferMessage, IMessage> {
        public IMessage onMessage(NameTransferMessage message, MessageContext ctx) {
            WanionLib.proxy.getThreadListener().func_152344_a(() -> {
                EntityPlayer entityPlayer = WanionLib.proxy.getEntityPlayerFromContext(ctx);
                if (entityPlayer != null && entityPlayer.field_71070_bA instanceof INameAcceptorContainer && entityPlayer.field_71070_bA.field_75152_c == message.windowId) {
                    ((INameAcceptorContainer)entityPlayer.field_71070_bA).acceptName(message.name);
                }
            });
            return null;
        }
    }
}

