/*
 * Decompiled with CFR 0.152.
 */
package wanion.lib.client.gui;

import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import wanion.lib.client.gui.WGuiContainer;
import wanion.lib.client.gui.interaction.WInteraction;
import wanion.lib.client.gui.interaction.WKeyInteraction;
import wanion.lib.client.gui.interaction.WMouseInteraction;

@SideOnly(value=Side.CLIENT)
public abstract class WElement {
    protected final WGuiContainer<?> wGuiContainer;
    protected final int width;
    protected final int height;
    protected int x;
    protected int y;
    protected boolean enabled = true;

    public WElement(@Nonnull WGuiContainer<?> wGuiContainer, int x, int y, int width, int height) {
        this.wGuiContainer = wGuiContainer;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public final int getX() {
        return this.x;
    }

    public final int getUsableX() {
        return this.wGuiContainer.getGuiLeft() + this.x;
    }

    public final void setX(int x) {
        this.x = x;
    }

    public final int getY() {
        return this.y;
    }

    public final int getUsableY() {
        return this.wGuiContainer.getGuiTop() + this.y;
    }

    public final void setY(int y) {
        this.y = y;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public final int getWindowID() {
        return this.wGuiContainer.field_147002_h.field_75152_c;
    }

    @Nonnull
    public final WGuiContainer<?> getWGuiContainer() {
        return this.wGuiContainer;
    }

    @Nonnull
    public final EntityPlayer getEntityPlayer() {
        return this.wGuiContainer.getEntityPlayer();
    }

    public final boolean isEnabled() {
        return this.enabled;
    }

    public final void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean canInteractWith(@Nonnull WInteraction wInteraction) {
        return wInteraction.isHovering(this);
    }

    public void interaction(@Nonnull WInteraction wInteraction) {
        if (wInteraction instanceof WKeyInteraction) {
            this.interaction((WKeyInteraction)wInteraction);
        } else if (wInteraction instanceof WMouseInteraction) {
            this.interaction((WMouseInteraction)wInteraction);
        }
    }

    public void interaction(@Nonnull WKeyInteraction wKeyInteraction) {
    }

    public void interaction(@Nonnull WMouseInteraction wMouseInteraction) {
    }

    public abstract void draw(@Nonnull WInteraction var1);

    public void drawForeground(@Nonnull WInteraction wInteraction) {
    }

    public int getTooltipX(@Nonnull WInteraction wInteraction) {
        return wInteraction.getMouseX() - this.wGuiContainer.getGuiLeft();
    }

    public int getTooltipY(@Nonnull WInteraction wInteraction) {
        return wInteraction.getMouseY() - this.wGuiContainer.getGuiTop();
    }

    public SoundHandler getSoundHandler() {
        return Minecraft.func_71410_x().func_147118_V();
    }

    public TextureManager getTextureManager() {
        return Minecraft.func_71410_x().func_110434_K();
    }

    public FontRenderer getFontRenderer() {
        return Minecraft.func_71410_x().field_71466_p;
    }

    public void playPressSound() {
        this.getSoundHandler().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
    }

    public void playPressSound(@Nonnull ISound sound) {
        this.getSoundHandler().func_147682_a(sound);
    }
}

