/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.api.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thelm.jaopca.api.IOreEntry;
import thelm.jaopca.api.ItemEntry;
import thelm.jaopca.api.block.IBlockWithProperty;

public class BlockBase
extends Block
implements IBlockWithProperty {
    public final IOreEntry oreEntry;
    public final ItemEntry itemEntry;
    protected boolean beaconBase = false;
    protected AxisAlignedBB boundingBox = field_185505_j;
    protected String harvestTool = null;
    protected int harvestLevel = -1;
    protected boolean full = true;
    protected boolean opaque = true;
    protected BlockRenderLayer layer = BlockRenderLayer.CUTOUT;
    protected int flammability = 0;
    protected int fireSpreadSpeed = 0;
    protected boolean fireSource = false;
    protected boolean fallable = false;

    public BlockBase(Material material, MapColor mapColor, ItemEntry itemEntry, IOreEntry oreEntry) {
        super(material, mapColor);
        this.func_149663_c("jaopca." + itemEntry.name);
        this.setRegistryName("jaopca:block_" + itemEntry.name + oreEntry.getOreName());
        this.oreEntry = oreEntry;
        this.itemEntry = itemEntry;
    }

    @Override
    public IOreEntry getOreEntry() {
        return this.oreEntry;
    }

    @Override
    public ItemEntry getItemEntry() {
        return this.itemEntry;
    }

    @Override
    public BlockBase setSoundType(SoundType sound) {
        super.func_149672_a(sound);
        return this;
    }

    @Override
    public BlockBase setLightOpacity(int opacity) {
        super.func_149713_g(opacity);
        return this;
    }

    @Override
    public BlockBase setLightLevel(float value) {
        super.func_149715_a(value);
        return this;
    }

    @Override
    public BlockBase setResistance(float resistance) {
        super.func_149752_b(resistance);
        return this;
    }

    @Override
    public BlockBase setHardness(float hardness) {
        super.func_149711_c(hardness);
        return this;
    }

    @Override
    public BlockBase setSlipperiness(float slipperiness) {
        this.field_149765_K = slipperiness;
        return this;
    }

    @Override
    public BlockBase setBeaconBase(boolean beaconBase) {
        this.beaconBase = beaconBase;
        return this;
    }

    public boolean isBeaconBase(IBlockAccess worldObj, BlockPos pos, BlockPos beacon) {
        return this.beaconBase;
    }

    @Override
    public BlockBase setBoundingBox(AxisAlignedBB boundingBox) {
        this.boundingBox = boundingBox;
        return this;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return this.boundingBox;
    }

    @Override
    public BlockBase setHarvestTool(String harvestTool) {
        this.harvestTool = harvestTool;
        return this;
    }

    @Override
    public BlockBase setHarvestLevel(int harvestLevel) {
        this.harvestLevel = harvestLevel;
        return this;
    }

    public String getHarvestTool(IBlockState state) {
        return this.harvestTool;
    }

    public int getHarvestLevel(IBlockState state) {
        return this.harvestLevel;
    }

    @Override
    public BlockBase setFull(boolean full) {
        this.full = full;
        return this;
    }

    @Override
    public BlockBase setOpaque(boolean opaque) {
        this.opaque = opaque;
        return this;
    }

    public boolean func_149686_d(IBlockState state) {
        return this.full;
    }

    public boolean func_149662_c(IBlockState state) {
        return this.opaque;
    }

    @Override
    public BlockBase setBlockLayer(BlockRenderLayer layer) {
        this.layer = layer;
        return this;
    }

    public BlockRenderLayer func_180664_k() {
        return this.layer;
    }

    @Override
    public BlockBase setFlammability(int flammability) {
        this.flammability = flammability;
        return this;
    }

    @Override
    public BlockBase setFireSpreadSpeed(int fireSpreadSpeed) {
        this.fireSpreadSpeed = fireSpreadSpeed;
        return this;
    }

    @Override
    public BlockBase setFireSource(boolean fireSource) {
        this.fireSource = fireSource;
        return this;
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return this.flammability;
    }

    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return this.fireSpreadSpeed;
    }

    public boolean isFireSource(World world, BlockPos pos, EnumFacing side) {
        return this.fireSource && side == EnumFacing.UP;
    }

    public int func_149738_a(World worldIn) {
        return 2;
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        if (this.fallable) {
            worldIn.func_175684_a(pos, (Block)this, this.func_149738_a(worldIn));
        }
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (this.fallable) {
            worldIn.func_175684_a(pos, (Block)this, this.func_149738_a(worldIn));
        }
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (this.fallable && !worldIn.field_72995_K) {
            this.checkFallable(worldIn, pos);
        }
    }

    private void checkFallable(World worldIn, BlockPos pos) {
        if (this.fallable && (worldIn.func_175623_d(pos.func_177977_b()) || BlockFalling.func_185759_i((IBlockState)worldIn.func_180495_p(pos.func_177977_b()))) && pos.func_177956_o() >= 0) {
            int i = 32;
            if (!BlockFalling.field_149832_M && worldIn.func_175707_a(pos.func_177982_a(-32, -32, -32), pos.func_177982_a(32, 32, 32))) {
                if (!worldIn.field_72995_K) {
                    EntityFallingBlock entityfallingblock = new EntityFallingBlock(worldIn, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, worldIn.func_180495_p(pos));
                    worldIn.func_72838_d((Entity)entityfallingblock);
                }
            } else {
                IBlockState state = worldIn.func_180495_p(pos);
                worldIn.func_175698_g(pos);
                BlockPos blockpos = pos.func_177977_b();
                while ((worldIn.func_175623_d(blockpos) || BlockFalling.func_185759_i((IBlockState)worldIn.func_180495_p(blockpos))) && blockpos.func_177956_o() > 0) {
                    blockpos = blockpos.func_177977_b();
                }
                if (blockpos.func_177956_o() > 0) {
                    worldIn.func_175656_a(blockpos.func_177984_a(), state);
                }
            }
        }
    }

    @Override
    public BlockBase setFallable(boolean fallable) {
        this.fallable = fallable;
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        BlockPos blockpos;
        if (this.fallable && rand.nextInt(16) == 0 && BlockFalling.func_185759_i((IBlockState)worldIn.func_180495_p(blockpos = pos.func_177977_b()))) {
            double d0 = (float)pos.func_177958_n() + rand.nextFloat();
            double d1 = (double)pos.func_177956_o() - 0.05;
            double d2 = (float)pos.func_177952_p() + rand.nextFloat();
            worldIn.func_175688_a(EnumParticleTypes.FALLING_DUST, d0, d1, d2, 0.0, 0.0, 0.0, new int[]{Block.func_176210_f((IBlockState)stateIn)});
        }
    }

    @Override
    public boolean hasSubtypes() {
        return false;
    }
}

