/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.renderer;

import javax.vecmath.Matrix4f;
import net.malisis.core.renderer.DefaultRenderer;
import net.malisis.core.renderer.MalisisRenderer;
import net.malisis.core.renderer.RenderParameters;
import net.malisis.core.renderer.RenderType;
import net.malisis.core.renderer.animation.Animation;
import net.malisis.core.renderer.animation.AnimationRenderer;
import net.malisis.core.renderer.element.Shape;
import net.malisis.core.renderer.element.shape.Cube;
import net.malisis.core.renderer.model.MalisisModel;
import net.malisis.core.util.TransformBuilder;
import net.malisis.doors.block.FenceGate;
import net.malisis.doors.tileentity.DoorTileEntity;
import net.malisis.doors.tileentity.FenceGateTileEntity;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.item.Item;
import net.minecraft.util.EnumFacing;

public class FenceGateRenderer
extends MalisisRenderer<FenceGateTileEntity> {
    private MalisisModel model;
    private RenderParameters rp;
    protected AnimationRenderer ar = new AnimationRenderer();
    private Matrix4f gui = new TransformBuilder().translate(0.0f, -0.05f, 0.0f).rotate(30.0f, 45.0f, 0.0f).scale(0.8f).get();

    public FenceGateRenderer() {
        this.registerFor(FenceGateTileEntity.class);
        this.ensureBlock(new Class[]{FenceGate.class});
    }

    protected void initialize() {
        float w = 0.125f;
        float w2 = 0.1875f;
        Shape hinge = new Cube().setSize(w, 0.6875f, w);
        hinge.translate(0.0f, 0.3125f, 0.5f - w / 2.0f);
        Shape gateH = new Cube().setSize(w, w2 * 3.0f, w);
        gateH.translate(0.5f - w, 0.375f, 0.5f - w / 2.0f);
        Shape gateBottom = new Cube().setSize(2.0f * w, w2, w);
        gateBottom.translate(w, 0.375f, 0.5f - w / 2.0f);
        Shape gateTop = new Shape(gateBottom);
        gateTop.translate(0.0f, 2.0f * w2, 0.0f);
        Shape right = Shape.fromShapes((Shape[])new Shape[]{hinge, gateH, gateBottom, gateTop});
        right.applyMatrix();
        right.interpolateUV();
        Shape left = new Shape(right);
        left.rotate(180.0f, 0.0f, 1.0f, 0.0f);
        left.applyMatrix();
        left.deductParameters();
        this.model = new MalisisModel();
        this.model.addShape("right", right);
        this.model.addShape("left", left);
        this.model.storeState();
        this.initParams();
    }

    protected void initParams() {
        this.rp = new RenderParameters();
        this.rp.useBlockBounds.set((Object)false);
        this.rp.renderAllFaces.set((Object)true);
        this.rp.interpolateUV.set((Object)false);
        this.rp.deductParameters.set((Object)true);
        this.rp.calculateAOColor.set((Object)false);
    }

    public boolean isGui3d() {
        return true;
    }

    public Matrix4f getTransform(Item item, ItemCameraTransforms.TransformType tranformType) {
        switch (tranformType) {
            case GUI: {
                return this.gui;
            }
        }
        return DefaultRenderer.block.getTransform(item, tranformType);
    }

    public void render() {
        if (this.renderType == RenderType.BLOCK) {
            return;
        }
        this.rp.icon.reset();
        this.rp.colorMultiplier.reset();
        if (this.renderType == RenderType.TILE_ENTITY) {
            this.setup();
            this.renderTileEntity();
        }
        if (this.renderType == RenderType.ITEM) {
            this.model.resetState();
            this.model.render((MalisisRenderer)this, this.rp);
            return;
        }
    }

    protected void setup() {
        this.model.resetState();
        if (((FenceGateTileEntity)this.tileEntity).getDirection().func_176740_k() == EnumFacing.Axis.X) {
            this.model.rotate(90.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        }
        if (((FenceGateTileEntity)this.tileEntity).isWall()) {
            this.model.translate(0.0f, -0.19f, 0.0f);
        }
        this.rp.colorMultiplier.set((Object)((FenceGateTileEntity)this.tileEntity).getCamoColor());
        this.rp.brightness.set((Object)this.blockState.func_185889_a(this.world, this.pos));
    }

    protected void renderTileEntity() {
        this.initParams();
        this.ar.setStartTime(((FenceGateTileEntity)this.tileEntity).getTimer().getStart());
        this.setup();
        if (((FenceGateTileEntity)this.tileEntity).getMovement() != null) {
            Animation<?>[] anims = ((FenceGateTileEntity)this.tileEntity).getMovement().getAnimations((DoorTileEntity)this.tileEntity, this.model, this.rp);
            this.ar.animate(anims);
        }
        this.model.render((MalisisRenderer)this, this.rp);
    }
}

