/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.movement;

import net.malisis.core.block.BoundingBoxType;
import net.malisis.core.renderer.RenderParameters;
import net.malisis.core.renderer.animation.Animation;
import net.malisis.core.renderer.animation.transformation.ChainedTransformation;
import net.malisis.core.renderer.animation.transformation.ITransformable;
import net.malisis.core.renderer.animation.transformation.Rotation;
import net.malisis.core.renderer.animation.transformation.Transformation;
import net.malisis.core.renderer.animation.transformation.Translation;
import net.malisis.core.renderer.model.MalisisModel;
import net.malisis.core.util.AABBUtils;
import net.malisis.doors.DoorState;
import net.malisis.doors.movement.IDoorMovement;
import net.malisis.doors.tileentity.DoorTileEntity;
import net.minecraft.util.math.AxisAlignedBB;

public class RotateAndPlaceMovement
implements IDoorMovement {
    @Override
    public AxisAlignedBB getOpenBoundingBox(DoorTileEntity tileEntity, boolean topBlock, BoundingBoxType type) {
        AxisAlignedBB aabb = IDoorMovement.getFullBoundingBox(topBlock, type);
        aabb = AABBUtils.rotate((AxisAlignedBB)aabb, (int)(tileEntity.isHingeLeft() ? -1 : 1));
        aabb = aabb.func_72317_d(0.0, 0.0, -0.5);
        return aabb;
    }

    private ChainedTransformation getTransformation(DoorTileEntity tileEntity) {
        int ot = tileEntity.getDescriptor().getOpeningTime() / 2;
        float angle = tileEntity.isHingeLeft() ? 90.0f : -90.0f;
        Rotation rotation = (Rotation)new Rotation(angle).aroundAxis(0.0f, 1.0f, 0.0f).offset(0.0f, 0.0f, -0.5f).forTicks(ot);
        Translation translation = (Translation)new Translation(0.0f, 0.0f, 0.3125f).forTicks(ot);
        ChainedTransformation transformation = new ChainedTransformation(new Transformation[]{rotation, translation});
        transformation.reversed(tileEntity.getState() == DoorState.CLOSING || tileEntity.getState() == DoorState.CLOSED);
        return transformation;
    }

    @Override
    public Animation<?>[] getAnimations(DoorTileEntity tileEntity, MalisisModel model, RenderParameters rp) {
        return new Animation[]{new Animation((ITransformable)model, (Transformation)this.getTransformation(tileEntity))};
    }

    @Override
    public boolean isSpecial() {
        return false;
    }
}

