/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.command.system;

import icbm.classic.command.CommandUtils;
import icbm.classic.command.sub.CommandHelp;
import icbm.classic.command.system.ICommandGroup;
import icbm.classic.command.system.ISubCommand;
import icbm.classic.command.system.SubCommand;
import icbm.classic.lib.MapWithDefault;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;

public class CommandGroup
extends SubCommand
implements ICommandGroup {
    private final MapWithDefault<String, ISubCommand> subCommandMap = new MapWithDefault();

    public CommandGroup(String id) {
        super(id);
        CommandHelp helpCommand = new CommandHelp();
        this.registerCommand(helpCommand);
        this.subCommandMap.setDefaultValue(helpCommand);
    }

    @Override
    public Collection<ISubCommand> getSubCommands() {
        return this.subCommandMap.values();
    }

    @Override
    public void registerCommand(ISubCommand command) {
        command.setParent(this);
        this.subCommandMap.put(command.getName().toLowerCase(), command);
    }

    @Override
    public void handleCommand(@Nonnull MinecraftServer server, @Nonnull ICommandSender sender, @Nonnull String[] args) throws CommandException {
        String subCommand = args.length == 0 ? "help" : args[0].toLowerCase();
        this.subCommandMap.get(subCommand).handleCommand(server, sender, CommandUtils.removeFront(args));
    }

    @Override
    public List<String> getTabSuggestions(@Nonnull MinecraftServer server, @Nonnull ICommandSender sender, @Nonnull String[] args, @Nullable BlockPos targetPos) {
        if (args.length == 1) {
            return CommandBase.func_175762_a((String[])args, this.subCommandMap.keySet());
        }
        if (args.length >= 2) {
            String subCommand = args[0].toLowerCase();
            return this.subCommandMap.get(subCommand).getTabSuggestions(server, sender, CommandUtils.removeFront(args), targetPos);
        }
        return Collections.emptyList();
    }
}

