/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.commands.user;

import java.util.UUID;
import me.lucko.luckperms.common.actionlog.LoggedAction;
import me.lucko.luckperms.common.command.CommandResult;
import me.lucko.luckperms.common.command.abstraction.ChildCommand;
import me.lucko.luckperms.common.command.access.ArgumentPermissions;
import me.lucko.luckperms.common.command.access.CommandPermission;
import me.lucko.luckperms.common.command.spec.CommandSpec;
import me.lucko.luckperms.common.command.utils.ArgumentList;
import me.lucko.luckperms.common.command.utils.StorageAssistant;
import me.lucko.luckperms.common.locale.Message;
import me.lucko.luckperms.common.model.User;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.util.Predicates;
import net.luckperms.api.model.data.DataType;

public class UserClone
extends ChildCommand<User> {
    public UserClone() {
        super(CommandSpec.USER_CLONE, "clone", CommandPermission.USER_CLONE, Predicates.not(1));
    }

    @Override
    public CommandResult execute(LuckPermsPlugin plugin, Sender sender, User target, ArgumentList args, String label) {
        if (ArgumentPermissions.checkViewPerms(plugin, sender, this.getPermission().get(), target)) {
            Message.COMMAND_NO_PERMISSION.send(sender);
            return CommandResult.NO_PERMISSION;
        }
        UUID uuid = args.getUserTarget(0, plugin, sender);
        if (uuid == null) {
            return CommandResult.INVALID_ARGS;
        }
        User otherUser = plugin.getStorage().loadUser(uuid, null).join();
        if (otherUser == null) {
            Message.USER_LOAD_ERROR.send(sender);
            return CommandResult.LOADING_ERROR;
        }
        if (ArgumentPermissions.checkModifyPerms(plugin, sender, this.getPermission().get(), otherUser)) {
            Message.COMMAND_NO_PERMISSION.send(sender);
            return CommandResult.NO_PERMISSION;
        }
        otherUser.setNodes(DataType.NORMAL, target.normalData().asList(), false);
        Message.CLONE_SUCCESS.send(sender, target.getFormattedDisplayName(), otherUser.getFormattedDisplayName());
        LoggedAction.build().source(sender).target(otherUser).description("clone", target.getUsername()).build().submit(plugin, sender);
        StorageAssistant.save(otherUser, sender, plugin);
        plugin.getUserManager().getHouseKeeper().cleanup(otherUser.getUniqueId());
        return CommandResult.SUCCESS;
    }
}

