/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.calculator.processor;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import me.lucko.luckperms.common.calculator.processor.AbstractPermissionProcessor;
import me.lucko.luckperms.common.calculator.processor.PermissionProcessor;
import me.lucko.luckperms.common.calculator.result.TristateResult;
import me.lucko.luckperms.common.node.types.RegexPermission;
import net.luckperms.api.util.Tristate;

public class RegexProcessor
extends AbstractPermissionProcessor
implements PermissionProcessor {
    private static final TristateResult.Factory RESULT_FACTORY = new TristateResult.Factory(RegexProcessor.class);
    private List<Map.Entry<Pattern, TristateResult>> regexPermissions = Collections.emptyList();

    @Override
    public TristateResult hasPermission(String permission) {
        for (Map.Entry<Pattern, TristateResult> e : this.regexPermissions) {
            if (!e.getKey().matcher(permission).matches()) continue;
            return e.getValue();
        }
        return TristateResult.UNDEFINED;
    }

    @Override
    public void refresh() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Map.Entry e : this.sourceMap.entrySet()) {
            Pattern pattern;
            RegexPermission.Builder regexPerm = RegexPermission.parse((String)e.getKey());
            if (regexPerm == null || (pattern = (Pattern)regexPerm.build().getPattern().orElse(null)) == null) continue;
            TristateResult value = RESULT_FACTORY.result(Tristate.of((Boolean)e.getValue()), "pattern: " + pattern.pattern());
            builder.add((Object)Maps.immutableEntry((Object)pattern, (Object)value));
        }
        this.regexPermissions = builder.build();
    }
}

