/*
 * Decompiled with CFR 0.152.
 */
package io.github.phantamanta44.libnine.util.world;

import io.github.phantamanta44.libnine.util.ImpossibilityRealizedException;
import io.github.phantamanta44.libnine.util.format.ILocalizable;
import io.github.phantamanta44.libnine.util.world.WorldBlockPos;
import java.util.function.Predicate;

public enum RedstoneBehaviour implements ILocalizable
{
    IGNORED(p -> true),
    DIRECT(p -> p.getWorld().func_175640_z(p.getPos())),
    INVERTED(p -> !p.getWorld().func_175640_z(p.getPos()));

    private final Predicate<WorldBlockPos> pred;

    private RedstoneBehaviour(Predicate<WorldBlockPos> pred) {
        this.pred = pred;
    }

    public boolean canWork(WorldBlockPos pos) {
        return this.pred.test(pos);
    }

    @Override
    public String getTranslationKey() {
        switch (this) {
            case IGNORED: {
                return "libnine.info.redstone_behaviour.ignored";
            }
            case DIRECT: {
                return "libnine.info.redstone_behaviour.direct";
            }
            case INVERTED: {
                return "libnine.info.redstone_behaviour.inverted";
            }
        }
        throw new ImpossibilityRealizedException();
    }
}

