/*
 * Decompiled with CFR 0.152.
 */
package io.github.phantamanta44.libnine.block.state;

import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;

public interface IBlockModelMapper {
    public static IBlockModelMapper toModel(Function<IBlockState, String> mapper) {
        return new ToModel(mapper);
    }

    public static IBlockModelMapper toVariant(String model, Function<IBlockState, String> mapper) {
        return new ToVariant(model, mapper);
    }

    public String getModel(IBlockState var1);

    @Nullable
    public String getVariant(IBlockState var1);

    public static class ToVariant
    implements IBlockModelMapper {
        private final String model;
        private final Function<IBlockState, String> mapper;

        ToVariant(String model, Function<IBlockState, String> mapper) {
            this.model = model;
            this.mapper = mapper;
        }

        @Override
        public String getModel(IBlockState state) {
            return this.model;
        }

        @Override
        @Nullable
        public String getVariant(IBlockState state) {
            return this.mapper.apply(state);
        }
    }

    public static class ToModel
    implements IBlockModelMapper {
        private final Function<IBlockState, String> mapper;

        ToModel(Function<IBlockState, String> mapper) {
            this.mapper = mapper;
        }

        @Override
        public String getModel(IBlockState state) {
            return this.mapper.apply(state);
        }

        @Override
        @Nullable
        public String getVariant(IBlockState state) {
            return "normal";
        }
    }
}

