/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.sponge.context;

import java.util.UUID;
import java.util.concurrent.TimeUnit;
import me.lucko.luckperms.common.context.ContextManager;
import me.lucko.luckperms.common.context.QueryOptionsCache;
import me.lucko.luckperms.common.context.QueryOptionsSupplier;
import me.lucko.luckperms.common.util.CaffeineFactory;
import me.lucko.luckperms.lib.caffeine.cache.LoadingCache;
import me.lucko.luckperms.sponge.LPSpongePlugin;
import net.luckperms.api.context.ImmutableContextSet;
import net.luckperms.api.query.QueryOptions;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.service.permission.Subject;

public class SpongeContextManager
extends ContextManager<Subject, Player> {
    private final LoadingCache<Subject, QueryOptionsCache<Subject>> subjectCaches = CaffeineFactory.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).build(key -> new QueryOptionsCache<Subject>((Subject)key, this));

    public SpongeContextManager(LPSpongePlugin plugin) {
        super(plugin, Subject.class, Player.class);
    }

    @Override
    public UUID getUniqueId(Player player) {
        return player.getUniqueId();
    }

    @Override
    public QueryOptionsSupplier getCacheFor(Subject subject) {
        if (subject == null) {
            throw new NullPointerException("subject");
        }
        return (QueryOptionsSupplier)this.subjectCaches.get((Object)subject);
    }

    @Override
    protected void invalidateCache(Subject subject) {
        QueryOptionsCache cache = (QueryOptionsCache)this.subjectCaches.getIfPresent((Object)subject);
        if (cache != null) {
            cache.invalidate();
        }
    }

    @Override
    public QueryOptions formQueryOptions(Subject subject, ImmutableContextSet contextSet) {
        return this.formQueryOptions(contextSet);
    }
}

