/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.treeview;

import com.google.common.base.Splitter;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import me.lucko.luckperms.common.plugin.scheduler.SchedulerAdapter;
import me.lucko.luckperms.common.plugin.scheduler.SchedulerTask;
import me.lucko.luckperms.common.treeview.TreeNode;
import me.lucko.luckperms.common.util.ImmutableCollectors;

public class PermissionRegistry
implements AutoCloseable {
    private static final Splitter DOT_SPLIT = Splitter.on((char)'.').omitEmptyStrings();
    private final TreeNode rootNode = new TreeNode();
    private final Queue<String> queue = new ConcurrentLinkedQueue<String>();
    private final SchedulerTask task;

    public PermissionRegistry(SchedulerAdapter scheduler) {
        this.task = scheduler.asyncRepeating(this::tick, 1L, TimeUnit.SECONDS);
    }

    public TreeNode getRootNode() {
        return this.rootNode;
    }

    public List<String> rootAsList() {
        return (List)this.rootNode.makeImmutableCopy().getNodeEndings().stream().map(Map.Entry::getValue).collect(ImmutableCollectors.toList());
    }

    public void offer(String permission) {
        if (permission == null) {
            throw new NullPointerException("permission");
        }
        this.queue.offer(permission);
    }

    private void tick() {
        String e;
        while ((e = this.queue.poll()) != null) {
            this.insert(e);
        }
    }

    @Override
    public void close() {
        this.task.cancel();
    }

    public void insert(String permission) {
        try {
            this.doInsert(permission);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void doInsert(String permission) {
        Iterable parts = DOT_SPLIT.split((CharSequence)permission);
        TreeNode current = this.rootNode;
        for (String part : parts) {
            if ((current = current.tryInsert(part)) != null) continue;
            return;
        }
    }
}

