/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.node.types;

import java.util.Map;
import java.util.Objects;
import me.lucko.luckperms.common.node.AbstractNode;
import me.lucko.luckperms.common.node.AbstractNodeBuilder;
import net.luckperms.api.context.ImmutableContextSet;
import net.luckperms.api.node.metadata.NodeMetadataKey;
import net.luckperms.api.node.types.DisplayNameNode;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class DisplayName
extends AbstractNode<DisplayNameNode, DisplayNameNode.Builder>
implements DisplayNameNode {
    private static final String NODE_KEY = "displayname";
    private static final String NODE_MARKER = "displayname.";
    private final String displayName;

    public static String key(String displayName) {
        return NODE_MARKER + displayName;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String displayName) {
        return DisplayName.builder().displayName(displayName);
    }

    public DisplayName(String displayName, boolean value, long expireAt, ImmutableContextSet contexts, Map<NodeMetadataKey<?>, Object> metadata) {
        super(DisplayName.key(displayName), value, expireAt, contexts, metadata);
        this.displayName = displayName;
    }

    @Override
    public @NonNull String getDisplayName() {
        return this.displayName;
    }

    @Override
    public @NonNull Builder toBuilder() {
        return new Builder(this.displayName, this.value, this.expireAt, this.contexts, this.metadata);
    }

    public static @Nullable Builder parse(String key) {
        if (!key.toLowerCase().startsWith(NODE_MARKER)) {
            return null;
        }
        return DisplayName.builder().displayName(key.substring(NODE_MARKER.length()));
    }

    public static final class Builder
    extends AbstractNodeBuilder<DisplayNameNode, DisplayNameNode.Builder>
    implements DisplayNameNode.Builder {
        private String displayName;

        private Builder() {
            this.displayName = null;
        }

        public Builder(String displayName, boolean value, long expireAt, ImmutableContextSet context, Map<NodeMetadataKey<?>, Object> metadata) {
            super(value, expireAt, context, metadata);
            this.displayName = displayName;
        }

        @Override
        public @NonNull Builder displayName(@NonNull String displayName) {
            this.displayName = displayName;
            return this;
        }

        @Override
        public @NonNull DisplayName build() {
            Objects.requireNonNull(this.displayName, "displayName");
            return new DisplayName(this.displayName, this.value, this.expireAt, this.context.build(), this.metadata);
        }
    }
}

