/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.commands.log;

import java.util.List;
import me.lucko.luckperms.common.actionlog.Log;
import me.lucko.luckperms.common.actionlog.LoggedAction;
import me.lucko.luckperms.common.command.CommandResult;
import me.lucko.luckperms.common.command.abstraction.ChildCommand;
import me.lucko.luckperms.common.command.access.CommandPermission;
import me.lucko.luckperms.common.command.spec.CommandSpec;
import me.lucko.luckperms.common.command.tabcomplete.TabCompleter;
import me.lucko.luckperms.common.command.tabcomplete.TabCompletions;
import me.lucko.luckperms.common.command.utils.ArgumentList;
import me.lucko.luckperms.common.locale.Message;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.storage.misc.DataConstraints;
import me.lucko.luckperms.common.util.Paginated;
import me.lucko.luckperms.common.util.Predicates;

public class LogTrackHistory
extends ChildCommand<Log> {
    private static final int ENTRIES_PER_PAGE = 10;

    public LogTrackHistory() {
        super(CommandSpec.LOG_TRACK_HISTORY, "trackhistory", CommandPermission.LOG_TRACK_HISTORY, Predicates.notInRange(1, 2));
    }

    @Override
    public CommandResult execute(LuckPermsPlugin plugin, Sender sender, Log log, ArgumentList args, String label) {
        String track = args.get(0).toLowerCase();
        if (!DataConstraints.TRACK_NAME_TEST.test(track)) {
            Message.TRACK_INVALID_ENTRY.send(sender, track);
            return CommandResult.INVALID_ARGS;
        }
        Paginated<LoggedAction> content = new Paginated<LoggedAction>(log.getTrackHistory(track));
        int page = args.getIntOrDefault(1, Integer.MIN_VALUE);
        if (page != Integer.MIN_VALUE) {
            return LogTrackHistory.showLog(page, sender, content);
        }
        return LogTrackHistory.showLog(content.getMaxPages(10), sender, content);
    }

    private static CommandResult showLog(int page, Sender sender, Paginated<LoggedAction> log) {
        int maxPage = log.getMaxPages(10);
        if (maxPage == 0) {
            Message.LOG_NO_ENTRIES.send(sender);
            return CommandResult.STATE_ERROR;
        }
        if (page == Integer.MIN_VALUE) {
            page = maxPage;
        }
        if (page < 1 || page > maxPage) {
            Message.LOG_INVALID_PAGE_RANGE.send(sender, maxPage);
            return CommandResult.INVALID_ARGS;
        }
        List<Paginated.Entry<LoggedAction>> entries = log.getPage(page, 10);
        String name = ((LoggedAction)((Paginated.Entry)entries.stream().findAny().get()).value()).getTarget().getName();
        Message.LOG_HISTORY_TRACK_HEADER.send(sender, name, page, maxPage);
        for (Paginated.Entry<LoggedAction> e : entries) {
            Message.LOG_ENTRY.send(sender, e.position(), e.value());
        }
        return CommandResult.SUCCESS;
    }

    @Override
    public List<String> tabComplete(LuckPermsPlugin plugin, Sender sender, ArgumentList args) {
        return TabCompleter.create().at(0, TabCompletions.tracks(plugin)).complete((List<String>)((Object)args));
    }
}

