/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.um.api.attribute;

import com.valkyrieofnight.um.api.attribute.AttributeID;
import java.util.ArrayList;
import java.util.List;

public class AttributeIDRegistry {
    private static AttributeIDRegistry INSTANCE;
    protected List<AttributeID> attributes = new ArrayList<AttributeID>();

    public static AttributeIDRegistry getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new AttributeIDRegistry();
        }
        return INSTANCE;
    }

    private AttributeIDRegistry() {
    }

    public void registerAttribute(AttributeID attributeID) throws Exception {
        if (!this.hasAttribute(attributeID)) {
            if (attributeID.getCalculator() == null) {
                throw new Exception("AttributeID: " + attributeID.toString() + " is missing an Attribute Calculator");
            }
            this.attributes.add(attributeID);
        }
    }

    public boolean hasAttribute(AttributeID attributeID) {
        return this.attributes.contains(attributeID);
    }

    public AttributeID getAttributeIDFromString(String attributeID) {
        for (AttributeID atid : this.attributes) {
            if (atid.toString() != attributeID) continue;
            return atid;
        }
        return null;
    }
}

