/*
 * Decompiled with CFR 0.152.
 */
package com.erigitic.config;

import com.erigitic.config.AccountManager;
import com.erigitic.config.TECurrency;
import com.erigitic.config.TEEconomyTransactionEvent;
import com.erigitic.config.TETransactionResult;
import com.erigitic.config.TETransferResult;
import com.erigitic.main.TotalEconomy;
import com.erigitic.sql.SqlManager;
import com.erigitic.sql.SqlQuery;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import ninja.leaping.configurate.ConfigurationNode;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.service.context.Context;
import org.spongepowered.api.service.economy.Currency;
import org.spongepowered.api.service.economy.account.Account;
import org.spongepowered.api.service.economy.account.VirtualAccount;
import org.spongepowered.api.service.economy.transaction.ResultType;
import org.spongepowered.api.service.economy.transaction.TransactionResult;
import org.spongepowered.api.service.economy.transaction.TransactionType;
import org.spongepowered.api.service.economy.transaction.TransactionTypes;
import org.spongepowered.api.service.economy.transaction.TransferResult;
import org.spongepowered.api.text.Text;

public class TEVirtualAccount
implements VirtualAccount {
    private TotalEconomy totalEconomy;
    private AccountManager accountManager;
    private String identifier;
    private SqlManager sqlManager;
    private ConfigurationNode accountConfig;
    private boolean databaseActive;

    public TEVirtualAccount(TotalEconomy totalEconomy, AccountManager accountManager, String identifier) {
        this.totalEconomy = totalEconomy;
        this.accountManager = accountManager;
        this.identifier = identifier;
        this.accountConfig = accountManager.getAccountConfig();
        this.databaseActive = totalEconomy.isDatabaseEnabled();
        if (this.databaseActive) {
            this.sqlManager = totalEconomy.getSqlManager();
        }
    }

    public Text getDisplayName() {
        return Text.of((String)this.identifier);
    }

    public BigDecimal getDefaultBalance(Currency currency) {
        return ((TECurrency)currency).getStartingBalance();
    }

    public boolean hasBalance(Currency currency, Set<Context> contexts) {
        String currencyName = currency.getDisplayName().toPlain().toLowerCase();
        if (this.databaseActive) {
            SqlQuery sqlQuery = SqlQuery.builder(this.sqlManager.dataSource).select(currencyName + "_balance").from("virtual_accounts").where("uid").equals(this.identifier).build();
            return sqlQuery.recordExists();
        }
        return this.accountConfig.getNode(new Object[]{this.identifier, currencyName + "-balance"}).getValue() != null;
    }

    public BigDecimal getBalance(Currency currency, Set<Context> contexts) {
        if (this.hasBalance(currency, contexts)) {
            String currencyName = currency.getDisplayName().toPlain().toLowerCase();
            if (this.databaseActive) {
                SqlQuery sqlQuery = SqlQuery.builder(this.sqlManager.dataSource).select(currencyName + "_balance").from("virtual_accounts").where("uid").equals(this.identifier).build();
                return sqlQuery.getBigDecimal(BigDecimal.ZERO);
            }
            BigDecimal balance = new BigDecimal(this.accountConfig.getNode(new Object[]{this.identifier, currencyName + "-balance"}).getString());
            return balance;
        }
        return BigDecimal.ZERO;
    }

    public Map<Currency, BigDecimal> getBalances(Set<Context> contexts) {
        return new HashMap<Currency, BigDecimal>();
    }

    public TransactionResult setBalance(Currency currency, BigDecimal amount, Cause cause, Set<Context> contexts) {
        TETransactionResult transactionResult;
        String currencyName = currency.getDisplayName().toPlain().toLowerCase();
        if (this.hasBalance(currency, contexts)) {
            TransactionType transactionType;
            BigDecimal delta = amount.subtract(this.getBalance(currency));
            TransactionType transactionType2 = transactionType = delta.compareTo(BigDecimal.ZERO) >= 0 ? TransactionTypes.DEPOSIT : TransactionTypes.WITHDRAW;
            if (this.databaseActive) {
                SqlQuery sqlQuery = SqlQuery.builder(this.sqlManager.dataSource).update("virtual_accounts").set(currencyName + "_balance").equals(amount.setScale(2, 1).toPlainString()).where("uid").equals(this.identifier).build();
                transactionResult = sqlQuery.getRowsAffected() > 0 ? new TETransactionResult((Account)this, currency, delta.abs(), contexts, ResultType.SUCCESS, transactionType) : new TETransactionResult((Account)this, currency, delta.abs(), contexts, ResultType.FAILED, transactionType);
            } else {
                this.accountConfig.getNode(new Object[]{this.identifier, currencyName + "-balance"}).setValue((Object)amount.setScale(2, 1));
                this.accountManager.requestConfigurationSave();
                transactionResult = new TETransactionResult((Account)this, currency, delta.abs(), contexts, ResultType.SUCCESS, transactionType);
            }
        } else {
            transactionResult = new TETransactionResult((Account)this, currency, BigDecimal.ZERO, contexts, ResultType.FAILED, TransactionTypes.DEPOSIT);
        }
        this.totalEconomy.getGame().getEventManager().post((Event)new TEEconomyTransactionEvent(transactionResult));
        return transactionResult;
    }

    public Map<Currency, TransactionResult> resetBalances(Cause cause, Set<Context> contexts) {
        TETransactionResult transactionResult = new TETransactionResult((Account)this, this.totalEconomy.getDefaultCurrency(), BigDecimal.ZERO, contexts, ResultType.FAILED, TransactionTypes.WITHDRAW);
        this.totalEconomy.getGame().getEventManager().post((Event)new TEEconomyTransactionEvent(transactionResult));
        HashMap<Currency, TransactionResult> result = new HashMap<Currency, TransactionResult>();
        result.put(this.totalEconomy.getDefaultCurrency(), transactionResult);
        return result;
    }

    public TransactionResult resetBalance(Currency currency, Cause cause, Set<Context> contexts) {
        return this.setBalance(currency, BigDecimal.ZERO, cause);
    }

    public TransactionResult deposit(Currency currency, BigDecimal amount, Cause cause, Set<Context> contexts) {
        BigDecimal curBalance = this.getBalance(currency, contexts);
        BigDecimal newBalance = curBalance.add(amount);
        return this.setBalance(currency, newBalance, cause);
    }

    public TransactionResult withdraw(Currency currency, BigDecimal amount, Cause cause, Set<Context> contexts) {
        BigDecimal curBalance = this.getBalance(currency, contexts);
        BigDecimal newBalance = curBalance.subtract(amount);
        if (newBalance.compareTo(BigDecimal.ZERO) >= 0) {
            return this.setBalance(currency, newBalance, cause);
        }
        return new TETransactionResult((Account)this, currency, amount, contexts, ResultType.ACCOUNT_NO_FUNDS, TransactionTypes.WITHDRAW);
    }

    public TransferResult transfer(Account to, Currency currency, BigDecimal amount, Cause cause, Set<Context> contexts) {
        if (this.hasBalance(currency, contexts)) {
            BigDecimal curBalance = this.getBalance(currency, contexts);
            BigDecimal newBalance = curBalance.subtract(amount);
            if (newBalance.compareTo(BigDecimal.ZERO) >= 0) {
                this.withdraw(currency, amount, cause, contexts);
                if (to.hasBalance(currency)) {
                    to.deposit(currency, amount, cause, contexts);
                    TETransferResult transferResult = new TETransferResult((Account)this, to, currency, amount, contexts, ResultType.SUCCESS, TransactionTypes.TRANSFER);
                    this.totalEconomy.getGame().getEventManager().post((Event)new TEEconomyTransactionEvent((TransactionResult)transferResult));
                    return transferResult;
                }
                TETransferResult transferResult = new TETransferResult((Account)this, to, currency, amount, contexts, ResultType.FAILED, TransactionTypes.TRANSFER);
                this.totalEconomy.getGame().getEventManager().post((Event)new TEEconomyTransactionEvent((TransactionResult)transferResult));
                return transferResult;
            }
            TETransferResult transferResult = new TETransferResult((Account)this, to, currency, amount, contexts, ResultType.ACCOUNT_NO_FUNDS, TransactionTypes.TRANSFER);
            this.totalEconomy.getGame().getEventManager().post((Event)new TEEconomyTransactionEvent((TransactionResult)transferResult));
            return transferResult;
        }
        TETransferResult transferResult = new TETransferResult((Account)this, to, currency, amount, contexts, ResultType.FAILED, TransactionTypes.TRANSFER);
        this.totalEconomy.getGame().getEventManager().post((Event)new TEEconomyTransactionEvent((TransactionResult)transferResult));
        return transferResult;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public Set<Context> getActiveContexts() {
        return new HashSet<Context>();
    }
}

