/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common;

import buildcraft.api.fuels.BuildcraftFuelRegistry;
import buildcraft.api.fuels.IFuel;
import buildcraft.api.mj.MjAPI;
import java.util.HashMap;
import java.util.Map;
import mekanism.api.gas.Gas;
import mekanism.common.config.MekanismConfig;
import mekanism.common.util.MekanismUtils;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.ModAPIManager;

public class FuelHandler {
    public static Map<String, FuelGas> fuels = new HashMap<String, FuelGas>();

    public static void addGas(Gas gas, int burnTicks, double energyPerMilliBucket) {
        fuels.put(gas.getName(), new FuelGas(burnTicks, energyPerMilliBucket));
    }

    public static FuelGas getFuel(Gas gas) {
        IFuel bcFuel;
        if (fuels.containsKey(gas.getName())) {
            return fuels.get(gas.getName());
        }
        if (FuelHandler.BCPresent() && gas.hasFluid() && BuildcraftFuelRegistry.fuel != null && (bcFuel = BuildcraftFuelRegistry.fuel.getFuel(new FluidStack(gas.getFluid(), 1))) != null) {
            FuelGas fuel = new FuelGas(bcFuel);
            fuels.put(gas.getName(), fuel);
            return fuel;
        }
        return null;
    }

    public static boolean BCPresent() {
        return ModAPIManager.INSTANCE.hasAPI("BuildCraftAPI|fuels") && MekanismUtils.classExists("buildcraft.api.fuels.BuildcraftFuelRegistry") && MekanismUtils.classExists("buildcraft.api.fuels.IFuel");
    }

    public static class FuelGas {
        public int burnTicks;
        public double energyPerTick;

        public FuelGas(int duration, double energyDensity) {
            this.burnTicks = duration;
            this.energyPerTick = energyDensity / (double)duration;
        }

        public FuelGas(IFuel bcFuel) {
            this.burnTicks = bcFuel.getTotalBurningTime() / 1000;
            this.energyPerTick = (double)bcFuel.getPowerPerCycle() / (double)MjAPI.MJ * 20.0 * MekanismConfig.current().general.FROM_RF.val();
        }
    }
}

