/*
 * Decompiled with CFR 0.152.
 */
package com.github.terminatornl.tiquality.world;

import com.github.terminatornl.tiquality.Tiquality;
import com.github.terminatornl.tiquality.concurrent.PausableThreadPoolExecutor;
import com.github.terminatornl.tiquality.interfaces.TiqualityChunk;
import com.github.terminatornl.tiquality.interfaces.TiqualityWorld;
import com.github.terminatornl.tiquality.interfaces.Tracker;
import com.github.terminatornl.tiquality.mixinhelper.MixinConfigPlugin;
import com.github.terminatornl.tiquality.util.FiFoQueue;
import com.github.terminatornl.tiquality.util.Utils;
import com.github.terminatornl.tiquality.world.SpongeChunkLoader;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class WorldHelper {
    private static final FiFoQueue<ScheduledAction> TASKS = new FiFoQueue();

    public static List<ChunkPos> getAffectedChunksInCuboid(BlockPos corner_1, BlockPos corner_2) {
        BlockPos start = Utils.BlockPos.getMin(corner_1, corner_2);
        BlockPos end = Utils.BlockPos.getMax(corner_1, corner_2);
        ChunkPos startChunk = new ChunkPos(start);
        ChunkPos endChunk = new ChunkPos(end);
        ArrayList<ChunkPos> posList = new ArrayList<ChunkPos>();
        for (int x = startChunk.field_77276_a; x <= endChunk.field_77276_a; ++x) {
            for (int z = startChunk.field_77275_b; z <= endChunk.field_77275_b; ++z) {
                posList.add(new ChunkPos(x, z));
            }
        }
        return posList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setTrackerCuboid(TiqualityWorld world, BlockPos corner_1, BlockPos corner_2, Tracker tracker, Runnable callback, Runnable beforeRun) {
        BlockPos start = Utils.BlockPos.getMin(corner_1, corner_2);
        BlockPos end = Utils.BlockPos.getMax(corner_1, corner_2);
        ChunkPos startChunk = new ChunkPos(start);
        ChunkPos endChunk = new ChunkPos(end);
        int affectedChunks = 0;
        FiFoQueue<ScheduledAction> fiFoQueue = TASKS;
        synchronized (fiFoQueue) {
            if (beforeRun != null) {
                TASKS.addToQueue(new CallBack(beforeRun));
            }
            for (int x = startChunk.field_77276_a; x <= endChunk.field_77276_a; ++x) {
                for (int z = startChunk.field_77275_b; z <= endChunk.field_77275_b; ++z) {
                    TASKS.addToQueue(new SetTrackerTask(world, new ChunkPos(x, z), start, end, tracker));
                    if (++affectedChunks % 40 != 0) continue;
                    TASKS.addToQueue(new SaveWorldTask((World)world));
                }
            }
            if (callback != null) {
                TASKS.addToQueue(new CallBack(callback));
            }
        }
        if (affectedChunks == 0) {
            Tiquality.LOGGER.warn("Tried to set a tracker in an area, but no chunks are affected!");
            Tiquality.LOGGER.warn("Low: " + start);
            Tiquality.LOGGER.warn("High: " + end);
            new Exception().printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getQueuedTasks() {
        FiFoQueue<ScheduledAction> fiFoQueue = TASKS;
        synchronized (fiFoQueue) {
            return TASKS.size();
        }
    }

    public static class SetTrackerTask
    implements ScheduledAction {
        private final TiqualityWorld world;
        private final ChunkPos chunkPos;
        private final BlockPos start;
        private final BlockPos end;
        private final Tracker tracker;
        private TiqualityChunk chunk = null;

        public SetTrackerTask(TiqualityWorld world, ChunkPos chunkPos, BlockPos start, BlockPos end, Tracker tracker) {
            this.world = world;
            this.chunkPos = chunkPos;
            this.start = start;
            this.end = end;
            this.tracker = tracker;
        }

        @Override
        public void run() {
            try {
                boolean isEntireChunk;
                if (this.chunk == null) {
                    throw new IllegalStateException("loadChunk() not called.");
                }
                int chunkXstart = this.chunkPos.func_180334_c();
                int chunkZstart = this.chunkPos.func_180333_d();
                int chunkXend = this.chunkPos.func_180332_e();
                int chunkZend = this.chunkPos.func_180330_f();
                int low_x = Math.max(this.start.func_177958_n(), chunkXstart);
                int low_y = this.start.func_177956_o();
                int low_z = Math.max(this.start.func_177952_p(), chunkZstart);
                int high_x = Math.min(this.end.func_177958_n(), chunkXend);
                int high_y = this.end.func_177956_o();
                int high_z = Math.min(this.end.func_177952_p(), chunkZend);
                boolean bl = isEntireChunk = this.chunkPos.func_180332_e() == high_x && this.chunkPos.func_180334_c() == low_x && this.chunkPos.func_180330_f() == high_z && this.chunkPos.func_180333_d() == low_z && low_y == 0 && high_y == this.world.getMinecraftWorld().func_72800_K() - 1;
                if (isEntireChunk) {
                    this.chunk.tiquality_setTrackerForEntireChunk(this.tracker);
                } else {
                    BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
                    for (int x = low_x; x <= high_x; ++x) {
                        for (int z = low_z; z <= high_z; ++z) {
                            for (int y = low_y; y <= high_y; ++y) {
                                this.chunk.tiquality_setTrackedPosition((BlockPos)pos.func_181079_c(x, y, z), this.tracker);
                            }
                        }
                    }
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
                throw t;
            }
        }

        @Override
        public boolean isCallback() {
            return false;
        }

        @Override
        public void loadChunk() {
            this.chunk = MixinConfigPlugin.spongePresent ? SpongeChunkLoader.getChunkForced(this.world, this.chunkPos) : this.world.getTiqualityChunk(this.chunkPos);
        }
    }

    public static class SaveWorldTask
    implements ScheduledAction {
        private final World world;

        public SaveWorldTask(World world) {
            this.world = world;
        }

        @Override
        public boolean isCallback() {
            return true;
        }

        @Override
        public void run() {
            this.world.func_72860_G().func_75759_a();
        }
    }

    public static class CallBack
    implements ScheduledAction {
        private final Runnable runnable;

        public CallBack(Runnable runnable) {
            this.runnable = runnable;
        }

        @Override
        public void run() {
            this.runnable.run();
        }

        @Override
        public boolean isCallback() {
            return true;
        }
    }

    public static class SmearedAction {
        public static final SmearedAction INSTANCE = new SmearedAction();
        private PausableThreadPoolExecutor threadPool = new PausableThreadPoolExecutor(16);

        private SmearedAction() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @SubscribeEvent
        public void onTick(TickEvent.ServerTickEvent event) {
            if (event.phase != TickEvent.Phase.START) {
                return;
            }
            try {
                this.threadPool.resume();
                long maxTime = System.currentTimeMillis() + 40L;
                while (System.currentTimeMillis() < maxTime) {
                    FiFoQueue fiFoQueue = TASKS;
                    synchronized (fiFoQueue) {
                        if (TASKS.size() == 0) {
                            return;
                        }
                        ScheduledAction action = (ScheduledAction)TASKS.take();
                        action.loadChunk();
                        if (!action.isCallback()) {
                            this.threadPool.submit(action);
                        } else {
                            this.threadPool.pause();
                            try {
                                action.run();
                            }
                            catch (Throwable t) {
                                t.printStackTrace();
                            }
                            if (TASKS.size() == 0) {
                                break;
                            }
                            this.threadPool.resume();
                        }
                    }
                }
                this.threadPool.finish();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    static interface ScheduledAction
    extends Runnable {
        public boolean isCallback();

        default public void loadChunk() {
        }
    }
}

