/*
 * Decompiled with CFR 0.152.
 */
package com.github.terminatornl.tiquality.world;

import com.github.terminatornl.tiquality.Tiquality;
import com.github.terminatornl.tiquality.interfaces.TiqualityChunk;
import com.github.terminatornl.tiquality.interfaces.TiqualityWorld;
import java.lang.reflect.Field;
import javax.annotation.Nonnull;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.ChunkProviderServer;
import org.spongepowered.common.bridge.world.WorldInfoBridge;
import org.spongepowered.common.bridge.world.chunk.ChunkBridge;
import org.spongepowered.common.config.category.WorldCategory;
import org.spongepowered.common.config.type.WorldConfig;
import org.spongepowered.common.world.SpongeEmptyChunk;

public class SpongeChunkLoader {
    @Nonnull
    public static TiqualityChunk getChunkForced(TiqualityWorld world, ChunkPos pos) {
        if (world instanceof WorldServer) {
            Chunk maybeFakeChunk = world.getMinecraftWorld().func_72964_e(pos.field_77276_a, pos.field_77275_b);
            if (!(maybeFakeChunk instanceof SpongeEmptyChunk)) {
                return (TiqualityChunk)maybeFakeChunk;
            }
            ChunkProviderServer provider = ((WorldServer)world).func_72863_F();
            if (provider instanceof ChunkBridge) {
                WorldCategory category = ((WorldConfig)((WorldInfoBridge)provider.field_73251_h.func_72912_H()).bridge$getConfigAdapter().getConfig()).getWorld();
                boolean isDenying = category.getDenyChunkRequests();
                if (isDenying) {
                    TiqualityChunk result;
                    try {
                        Field denyChunkRequestsField = WorldCategory.class.getDeclaredField("denyChunkRequests");
                        denyChunkRequestsField.set(category, false);
                        result = (TiqualityChunk)((WorldServer)world).func_72964_e(pos.field_77276_a, pos.field_77275_b);
                        denyChunkRequestsField.set(category, true);
                    }
                    catch (IllegalAccessException | NoSuchFieldException e) {
                        Tiquality.LOGGER.warn("Unable to set deny chunk requests temporarily! Undefined behavior ahead...");
                        e.printStackTrace();
                        result = (TiqualityChunk)((WorldServer)world).func_72964_e(pos.field_77276_a, pos.field_77275_b);
                    }
                    return result;
                }
                return (TiqualityChunk)provider.func_186025_d(pos.field_77276_a >> 4, pos.field_77275_b >> 4);
            }
        }
        return (TiqualityChunk)world.getMinecraftWorld().func_72863_F().func_186025_d(pos.field_77276_a >> 4, pos.field_77275_b >> 4);
    }
}

