/*
 * Decompiled with CFR 0.152.
 */
package com.github.terminatornl.tiquality.tracking;

import com.github.terminatornl.tiquality.Tiquality;
import com.github.terminatornl.tiquality.interfaces.TiqualityWorld;
import com.github.terminatornl.tiquality.interfaces.Tracker;
import com.github.terminatornl.tiquality.tracking.TrackerHolder;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.TreeMap;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;

public class TrackerManager {
    public static final HashMap<String, Class<? extends Tracker>> REGISTERED_TRACKER_TYPES = new HashMap();
    private static final TreeMap<Long, TrackerHolder> TRACKER_LIST = new TreeMap();
    private static final ReentrantLock TRACKER_LIST_LOCK = new ReentrantLock();

    public static <T> T foreach(Action<T> foreach) {
        TRACKER_LIST_LOCK.lock();
        try {
            for (TrackerHolder holder : TRACKER_LIST.values()) {
                foreach.each((Tracker)holder.getTracker());
                if (!((Action)foreach).stop) continue;
                break;
            }
            Iterator iterator = foreach.value;
            return (T)iterator;
        }
        catch (ConcurrentModificationException e) {
            Tiquality.LOGGER.warn("Concurrent modification exception occurred! To prevent a crash, we caught it. I need more eyes for this. See issues: #20 #22 and #41");
            e.printStackTrace();
            Object t = foreach.value;
            return t;
        }
        finally {
            TRACKER_LIST_LOCK.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static Tracker getTrackerByID(long id) {
        TRACKER_LIST_LOCK.lock();
        try {
            TrackerHolder holder = TRACKER_LIST.get(id);
            Tracker tracker = holder == null ? null : (Tracker)holder.getTracker();
            return tracker;
        }
        finally {
            TRACKER_LIST_LOCK.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void tickUntil(long time) {
        TRACKER_LIST_LOCK.lock();
        try {
            boolean hasWork = true;
            LinkedList<TrackerHolder> copiedHolders = new LinkedList<TrackerHolder>(TRACKER_LIST.values());
            while (System.nanoTime() < time && hasWork) {
                hasWork = false;
                for (TrackerHolder holder : copiedHolders) {
                    Object tracker = holder.getTracker();
                    if (!tracker.needsTick()) continue;
                    hasWork = true;
                    tracker.grantTick();
                }
            }
        }
        catch (ConcurrentModificationException e) {
            Tiquality.LOGGER.warn("Concurrent modification exception occurred! To prevent a crash, we caught it. I need more eyes for this. See issues: #20 #22 and #41");
            e.printStackTrace();
        }
        finally {
            TRACKER_LIST_LOCK.unlock();
        }
    }

    public static void removeInactiveTrackers() {
        TRACKER_LIST_LOCK.lock();
        try {
            TRACKER_LIST.entrySet().removeIf(entry -> {
                Object tracker = ((TrackerHolder)entry.getValue()).getTracker();
                if (tracker.shouldUnload()) {
                    tracker.onUnload();
                    return true;
                }
                return false;
            });
        }
        catch (ConcurrentModificationException e) {
            Tiquality.LOGGER.warn("Concurrent modification exception occurred! To prevent a crash, we caught it. I need more eyes for this. See issues: #20 #22 and #41");
            e.printStackTrace();
        }
        finally {
            TRACKER_LIST_LOCK.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static TrackerHolder readHolder(TiqualityWorld world, NBTTagCompound tagCompound) {
        String type = tagCompound.func_74779_i("type");
        if (type.equals("")) {
            return null;
        }
        long id = tagCompound.func_74763_f("id");
        TRACKER_LIST_LOCK.lock();
        try {
            TrackerHolder holder = TRACKER_LIST.get(id);
            if (holder != null) {
                TrackerHolder trackerHolder = holder;
                return trackerHolder;
            }
            TrackerHolder trackerHolder = holder = TrackerHolder.readHolder(world, tagCompound);
            return trackerHolder;
        }
        finally {
            TRACKER_LIST_LOCK.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static <T extends Tracker> TrackerHolder<T> createNewTrackerHolder(TiqualityWorld world, T tracker) {
        TRACKER_LIST_LOCK.lock();
        try {
            TrackerHolder holder = tracker.getHolder();
            if (holder != null) {
                throw new IllegalStateException("This tracker wants to be saved as if it was new, but it's not! : " + tracker.toString());
            }
            TrackerHolder<T> trackerHolder = TrackerHolder.createNewTrackerHolder(world, tracker);
            return trackerHolder;
        }
        finally {
            TRACKER_LIST_LOCK.unlock();
        }
    }

    public static void addTrackerHolder(TrackerHolder holder) {
        TRACKER_LIST_LOCK.lock();
        try {
            if (TRACKER_LIST.put(holder.getId(), holder) != null) {
                throw new IllegalStateException("Attempted to save two different trackerholder instances!");
            }
        }
        finally {
            TRACKER_LIST_LOCK.unlock();
        }
    }

    public static abstract class Action<T> {
        public T value = null;
        private boolean stop = false;

        public void stop(T value) {
            this.stop = true;
            this.value = value;
        }

        public abstract void each(Tracker var1);
    }
}

