/*
 * Decompiled with CFR 0.152.
 */
package com.github.terminatornl.tiquality.tracking;

import com.github.terminatornl.tiquality.Tiquality;
import com.github.terminatornl.tiquality.interfaces.TiqualityWorld;
import com.github.terminatornl.tiquality.interfaces.Tracker;
import com.github.terminatornl.tiquality.tracking.TrackerManager;
import com.github.terminatornl.tiquality.util.PersistentData;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;

public class TrackerHolder<T extends Tracker>
implements Comparable<TrackerHolder> {
    private final T tracker;
    private final long id;

    private TrackerHolder(@Nonnull T tracker, long id) {
        this.tracker = tracker;
        this.id = id;
        tracker.setHolder(this);
        TrackerManager.addTrackerHolder(this);
    }

    private TrackerHolder(@Nonnull T tracker) {
        this.tracker = tracker;
        this.id = TrackerHolder.generateUniqueTrackerID();
        PersistentData.ID_TO_TRACKER.lock();
        try {
            NBTTagCompound tag = PersistentData.ID_TO_TRACKER.getCompoundTag();
            tag.func_74782_a(Long.toString(this.id), (NBTBase)this.getHolderTag());
            PersistentData.ID_TO_TRACKER.setCompoundTag(tag);
            tracker.setHolder(this);
        }
        finally {
            PersistentData.ID_TO_TRACKER.unlock();
        }
        TrackerManager.addTrackerHolder(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long generateUniqueTrackerID() {
        PersistentData.NEXT_FREE_TRACKER_ID.lock();
        try {
            if (!PersistentData.NEXT_FREE_TRACKER_ID.isSet()) {
                PersistentData.NEXT_FREE_TRACKER_ID.setLong(Long.MIN_VALUE);
            }
            long granted = PersistentData.NEXT_FREE_TRACKER_ID.getLong();
            PersistentData.NEXT_FREE_TRACKER_ID.setLong(granted + 1L);
            long l = granted;
            return l;
        }
        finally {
            PersistentData.NEXT_FREE_TRACKER_ID.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static <T extends Tracker> TrackerHolder<T> getTrackerHolder(TiqualityWorld world, final long id) {
        NBTTagCompound tag;
        TrackerHolder holder = (TrackerHolder)TrackerManager.foreach(new TrackerManager.Action<TrackerHolder<T>>(){

            @Override
            public void each(Tracker tracker) {
                if (tracker.getHolder().getId() == id) {
                    this.stop(tracker.getHolder());
                }
            }
        });
        if (holder != null) {
            return holder;
        }
        PersistentData.ID_TO_TRACKER.lock();
        try {
            tag = PersistentData.ID_TO_TRACKER.getCompoundTag().func_74775_l(Long.toString(id));
        }
        finally {
            PersistentData.ID_TO_TRACKER.unlock();
        }
        if (tag.func_186856_d() == 0) {
            return null;
        }
        return TrackerHolder.readHolder(world, tag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static <T extends Tracker> TrackerHolder<T> createNewTrackerHolder(TiqualityWorld world, @Nonnull T tracker) {
        TrackerHolder<T> holder;
        NBTTagCompound root;
        String trackerIdentifier = tracker.getIdentifier();
        String trackerHashCode = Integer.toString(tracker.getHashCode());
        PersistentData.TRACKER_LOOKUP.lock();
        try {
            root = PersistentData.TRACKER_LOOKUP.getCompoundTag();
            NBTTagCompound type = root.func_74775_l(trackerIdentifier);
            NBTTagList hash = type.func_150295_c(trackerHashCode, 4);
            if (hash.func_74745_c() > 0) {
                for (NBTBase id : hash) {
                    TrackerHolder<T> existingHolder = TrackerHolder.getTrackerHolder(world, ((NBTTagLong)id).func_150291_c());
                    if (existingHolder == null) {
                        throw new IllegalStateException("Tried to load a tracker which exists in the system, but it somehow failed: " + id);
                    }
                    if (!existingHolder.getTracker().equals(tracker)) continue;
                    TrackerHolder<T> trackerHolder = existingHolder;
                    return trackerHolder;
                }
            }
            holder = new TrackerHolder<T>(tracker);
            hash.func_74742_a((NBTBase)new NBTTagLong(holder.getId()));
            type.func_74782_a(trackerHashCode, (NBTBase)hash);
            root.func_74782_a(trackerIdentifier, (NBTBase)type);
            PersistentData.TRACKER_LOOKUP.setCompoundTag(root);
        }
        finally {
            PersistentData.TRACKER_LOOKUP.unlock();
        }
        try {
            PersistentData.ID_TO_TRACKER.lock();
            root = PersistentData.ID_TO_TRACKER.getCompoundTag();
            root.func_74782_a(Long.toString(holder.getId()), (NBTBase)holder.getHolderTag());
            PersistentData.ID_TO_TRACKER.setCompoundTag(root);
            TrackerHolder<T> trackerHolder = holder;
            return trackerHolder;
        }
        finally {
            PersistentData.ID_TO_TRACKER.unlock();
        }
    }

    @Nullable
    public static TrackerHolder readHolder(TiqualityWorld world, NBTTagCompound tag) {
        long id = tag.func_74763_f("id");
        Tracker tracker = TrackerHolder.readTracker(world, tag);
        return tracker == null ? null : new TrackerHolder<Tracker>(tracker, id);
    }

    private static Tracker readTracker(TiqualityWorld world, NBTTagCompound holderTag) {
        String type = holderTag.func_74779_i("type");
        if (type.equals("")) {
            return null;
        }
        Class<? extends Tracker> clazz = TrackerManager.REGISTERED_TRACKER_TYPES.get(type);
        if (clazz == null) {
            return null;
        }
        NBTTagCompound trackerTag = holderTag.func_74775_l("data");
        try {
            return clazz.newInstance().load(world, trackerTag);
        }
        catch (Exception e) {
            Tiquality.LOGGER.warn("An exception has occurred whilst creating a tracker: " + trackerTag.toString());
            e.printStackTrace();
            return null;
        }
    }

    public NBTTagCompound getHolderTag() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("type", this.getTracker().getIdentifier());
        tag.func_74772_a("id", this.getId());
        tag.func_74782_a("data", (NBTBase)this.getTracker().getNBT());
        return tag;
    }

    public void update() {
        try {
            PersistentData.ID_TO_TRACKER.lock();
            NBTTagCompound root = PersistentData.ID_TO_TRACKER.getCompoundTag();
            root.func_74782_a(Long.toString(this.id), (NBTBase)this.getHolderTag());
            PersistentData.ID_TO_TRACKER.setCompoundTag(root);
        }
        finally {
            PersistentData.ID_TO_TRACKER.unlock();
        }
    }

    @Nonnull
    public T getTracker() {
        return this.tracker;
    }

    public long getId() {
        return this.id;
    }

    public boolean equals(Object o) {
        return o instanceof TrackerHolder && ((TrackerHolder)o).id == this.id;
    }

    @Override
    public int compareTo(@Nonnull TrackerHolder o) {
        return Long.compare(this.id, o.id);
    }
}

