/*
 * Decompiled with CFR 0.152.
 */
package com.github.terminatornl.tiquality.tracking;

import java.util.LinkedList;

public class TickWallet {
    private final LinkedList<TickWallet> subWallets = new LinkedList();
    private long remainingTime = 0L;

    public void setRemainingTime(long time) {
        this.remainingTime = time;
    }

    public long getTimeLeft() {
        long time = this.remainingTime;
        for (TickWallet subWallet : this.subWallets) {
            time += subWallet.remainingTime;
        }
        return time;
    }

    public void consume(long time) {
        if (this.remainingTime > 0L) {
            this.remainingTime -= time;
        } else {
            for (TickWallet subWallet : this.subWallets) {
                if (subWallet.remainingTime <= 0L) continue;
                subWallet.remainingTime -= time;
                return;
            }
        }
    }

    public void clearWallets() {
        this.subWallets.clear();
    }

    public void addWallet(TickWallet wallet) {
        this.subWallets.add(wallet);
    }
}

