/*
 * Decompiled with CFR 0.152.
 */
package com.github.terminatornl.tiquality.tracking;

import com.github.terminatornl.tiquality.Tiquality;
import com.github.terminatornl.tiquality.TiqualityConfig;
import com.github.terminatornl.tiquality.interfaces.TiqualityWorld;
import com.github.terminatornl.tiquality.interfaces.Tracker;
import com.github.terminatornl.tiquality.tracking.TickWallet;
import com.github.terminatornl.tiquality.tracking.TrackerBase;
import com.github.terminatornl.tiquality.tracking.TrackerHolder;
import com.github.terminatornl.tiquality.tracking.TrackerManager;
import com.github.terminatornl.tiquality.util.ForgeData;
import com.github.terminatornl.tiquality.util.Utils;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class PlayerTracker
extends TrackerBase {
    private final GameProfile profile;
    private final Set<Long> sharedTo = new HashSet<Long>();
    private final HashMap<String, ClaimOverrideRequester> pendingRequests = new HashMap();
    private boolean notifyUser = true;
    private long nextMessageMillis = 0L;
    private TickWallet wallet = new TickWallet();

    public PlayerTracker() {
        this.profile = ForgeData.GAME_PROFILE_NOBODY;
    }

    public PlayerTracker(@Nonnull GameProfile profile) {
        this.profile = profile;
    }

    @Nonnull
    public static PlayerTracker getOrCreatePlayerTrackerByProfile(TiqualityWorld world, @Nonnull GameProfile profile) {
        final UUID id = profile.getId();
        if (id == null) {
            throw new IllegalArgumentException("GameProfile must have an UUID");
        }
        PlayerTracker tracker = TrackerManager.foreach(new TrackerManager.Action<PlayerTracker>(){

            @Override
            public void each(Tracker tracker) {
                PlayerTracker playerTracker;
                if (tracker instanceof PlayerTracker && (playerTracker = (PlayerTracker)tracker).getOwner().getId().equals(id)) {
                    this.stop(playerTracker);
                }
            }
        });
        return tracker != null ? tracker : TrackerManager.createNewTrackerHolder(world, new PlayerTracker(profile)).getTracker();
    }

    public List<TextComponentString> getSharedToTextual(TiqualityWorld world) {
        LinkedList<TextComponentString> list = new LinkedList<TextComponentString>();
        for (long id : this.sharedTo) {
            TrackerHolder holder = TrackerHolder.getTrackerHolder(world, id);
            if (holder == null || !(holder.getTracker() instanceof PlayerTracker)) {
                this.switchSharedTo(id);
                list.add(new TextComponentString(TextFormatting.RED + "Tracker ID: " + id + " removed!"));
                continue;
            }
            list.add(new TextComponentString(TextFormatting.WHITE + ((PlayerTracker)holder.getTracker()).getOwner().getName()));
        }
        return list;
    }

    public boolean switchNotify() {
        this.notifyUser = !this.notifyUser;
        return this.notifyUser;
    }

    public boolean switchSharedTo(long id) {
        if (!this.sharedTo.contains(id)) {
            this.sharedTo.add(id);
            this.getHolder().update();
            return true;
        }
        this.sharedTo.remove(id);
        this.getHolder().update();
        return false;
    }

    public void requestClaimOverride(ClaimOverrideRequester requester, World world, BlockPos leastPos, BlockPos mostPos) throws CommandException {
        EntityPlayerMP thisPlayer = FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_177451_a(this.getOwner().getId());
        if (thisPlayer == null || thisPlayer.func_193105_t()) {
            requester.onOfflineOwner(this);
            return;
        }
        String requesterName = requester.getProfile().getName();
        String acceptString = "/tiquality acceptoverride " + requesterName;
        String denyString = "/tiquality denyoverride " + requesterName;
        if (this.pendingRequests.containsKey(requesterName.toLowerCase())) {
            throw new CommandException("You already have another pending request. Inform the owner to run: '" + acceptString + "' to accept your last request, or '" + denyString + "' to reject it.", new Object[0]);
        }
        this.pendingRequests.put(requesterName.toLowerCase(), requester);
        thisPlayer.func_145747_a((ITextComponent)new TextComponentString(Tiquality.PREFIX + requesterName + " wishes to claim an area that overlaps or is near your claim:"));
        thisPlayer.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GRAY + "  Affected area: X=" + leastPos.func_177958_n() + " Z=" + leastPos.func_177952_p() + " to X=" + mostPos.func_177958_n() + " Z=" + mostPos.func_177952_p()));
        thisPlayer.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GRAY + "  Affected dimension: " + world.field_73011_w.getDimension()));
        thisPlayer.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GRAY + "  Surface area of total claim: " + (mostPos.func_177958_n() - leastPos.func_177958_n()) * (mostPos.func_177952_p() - leastPos.func_177952_p())));
        thisPlayer.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GRAY + "To accept this request use: " + TextFormatting.GREEN + acceptString));
        thisPlayer.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GRAY + "To deny this request use: " + TextFormatting.RED + denyString));
    }

    public List<String> getOverrideRequests() {
        return new LinkedList<String>(this.pendingRequests.keySet());
    }

    public void acceptOverride(ICommandSender sender, String name) throws CommandException {
        ClaimOverrideRequester request = this.pendingRequests.remove(name.toLowerCase());
        if (request == null) {
            throw new CommandException("Request for: '" + name + "' was not found.", new Object[0]);
        }
        sender.func_145747_a((ITextComponent)new TextComponentString(Tiquality.PREFIX + "Accepted!"));
        request.onAccept(this);
    }

    public void denyOverride(ICommandSender sender, String name) throws CommandException {
        ClaimOverrideRequester request = this.pendingRequests.remove(name.toLowerCase());
        if (request == null) {
            throw new CommandException("Request for: '" + name + "' was not found.", new Object[0]);
        }
        sender.func_145747_a((ITextComponent)new TextComponentString(Tiquality.PREFIX + "Denied override!"));
        request.onDeny(this);
    }

    public void addWallet(TickWallet wallet) {
        this.wallet.addWallet(wallet);
    }

    public TickWallet getWallet() {
        return this.wallet;
    }

    @Override
    public void setNextTickTime(long time) {
        super.setNextTickTime(time);
        this.wallet.clearWallets();
        this.wallet.setRemainingTime(time);
    }

    @Override
    public void tick() {
        super.tick();
        for (Long id : this.sharedTo) {
            Tracker tracker = TrackerManager.getTrackerByID(id);
            if (!(tracker instanceof PlayerTracker)) continue;
            ((PlayerTracker)tracker).addWallet(this.wallet);
        }
    }

    @Override
    public void notifyFallingBehind(double ratio) {
        if (this.notifyUser && System.currentTimeMillis() > this.nextMessageMillis) {
            this.nextMessageMillis = System.currentTimeMillis() + (long)(TiqualityConfig.DEFAULT_THROTTLE_WARNING_INTERVAL_SECONDS * 1000);
            Entity e = FMLCommonHandler.instance().getMinecraftServerInstance().func_175576_a(this.getOwner().getId());
            if (e instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)e;
                player.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.RED + "Warning: " + TextFormatting.GRAY + "Your blocks tick at " + (double)Math.round(ratio * 10000.0) / 100.0 + "% speed." + TextFormatting.DARK_GRAY + " (/tiquality notify)"), true);
                double serverTPS_raw = Tiquality.TPS_MONITOR.getAverageTPS();
                String serverTPS = Utils.TWO_DECIMAL_FORMATTER.format((double)Math.round(serverTPS_raw * 100.0) / 100.0);
                String playerTPS = Utils.TWO_DECIMAL_FORMATTER.format((double)Math.round(serverTPS_raw * ratio * 100.0) / 100.0);
                player.func_145747_a((ITextComponent)new TextComponentString(Tiquality.PREFIX + "Your TPS: " + TextFormatting.WHITE + playerTPS + TextFormatting.GRAY + " (" + TextFormatting.WHITE + Math.round(ratio * 100.0) + "%" + TextFormatting.GRAY + ")" + TextFormatting.DARK_GRAY + " (/tiquality notify)"));
            }
        }
    }

    @Override
    public void consume(long time) {
        this.wallet.consume(time);
    }

    @Override
    public long getRemainingTime() {
        return this.wallet.getTimeLeft();
    }

    @Override
    public Tracker load(TiqualityWorld world, NBTTagCompound trackerTag) {
        PlayerTracker tracker = new PlayerTracker(ForgeData.getGameProfileByUUID(new UUID(trackerTag.func_74763_f("uuidMost"), trackerTag.func_74763_f("uuidLeast"))));
        if (trackerTag.func_74764_b("shared")) {
            NBTTagList shared = trackerTag.func_150295_c("shared", 4);
            for (NBTBase base : shared) {
                tracker.sharedTo.add(((NBTTagLong)base).func_150291_c());
            }
        }
        tracker.notifyUser = trackerTag.func_74767_n("notify");
        return tracker;
    }

    public boolean isPlayerOnline(GameProfile[] onlinePlayerProfiles) {
        for (GameProfile profile : onlinePlayerProfiles) {
            if (!this.profile.getId().equals(profile.getId())) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nonnull
    public NBTTagCompound getNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74772_a("uuidMost", this.profile.getId().getMostSignificantBits());
        tag.func_74772_a("uuidLeast", this.profile.getId().getLeastSignificantBits());
        tag.func_74757_a("notify", this.notifyUser);
        if (this.sharedTo.size() > 0) {
            NBTTagList sharedToTag = new NBTTagList();
            for (long id : this.sharedTo) {
                sharedToTag.func_74742_a((NBTBase)new NBTTagLong(id));
            }
            tag.func_74782_a("shared", (NBTBase)sharedToTag);
        }
        tag.func_74778_a("name", this.profile.getName());
        tag.func_74778_a("uuid", this.profile.getId().toString());
        return tag;
    }

    @Override
    public double getMultiplier(GameProfile[] cache) {
        return this.isPlayerOnline(cache) ? 1.0 : TiqualityConfig.OFFLINE_PLAYER_TICK_TIME_MULTIPLIER;
    }

    @Override
    @Nonnull
    public List<GameProfile> getAssociatedPlayers() {
        ArrayList<GameProfile> list = new ArrayList<GameProfile>();
        list.add(this.profile);
        return list;
    }

    public GameProfile getOwner() {
        return this.profile;
    }

    @Override
    public String toString() {
        return "PlayerTracker:{Owner: '" + this.getOwner().getName() + "', nsleft: " + this.tick_time_remaining_ns + ", unticked: " + this.tickQueue.size() + ", hashCode: " + System.identityHashCode(this) + "}";
    }

    @Override
    @Nonnull
    public TextComponentString getInfo() {
        return new TextComponentString(TextFormatting.GREEN + "Tracked by: " + TextFormatting.AQUA + this.getOwner().getName());
    }

    @Override
    @Nonnull
    public String getIdentifier() {
        return "PlayerTracker";
    }

    @Override
    public int getHashCode() {
        return this.getOwner().getId().hashCode();
    }

    @Override
    public boolean equalsSaved(NBTTagCompound tag) {
        UUID ownerUUID = new UUID(tag.func_74763_f("uuidMost"), tag.func_74763_f("uuidLeast"));
        return ownerUUID.equals(this.getOwner().getId());
    }

    public boolean equals(Object o) {
        if (!(o instanceof PlayerTracker)) {
            return false;
        }
        return o == this || this.getOwner().getId().equals(((PlayerTracker)o).getOwner().getId());
    }

    public int hashCode() {
        return this.getOwner().getId().hashCode();
    }

    public static interface ClaimOverrideRequester {
        public void onDeny(PlayerTracker var1);

        public void onOfflineOwner(PlayerTracker var1);

        public void onAccept(PlayerTracker var1);

        public GameProfile getProfile();
    }
}

