/*
 * Decompiled with CFR 0.152.
 */
package com.github.terminatornl.tiquality.profiling;

import com.github.terminatornl.tiquality.profiling.ReferencedTickable;
import com.github.terminatornl.tiquality.profiling.TickTime;
import io.netty.buffer.ByteBuf;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nullable;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class TickLogger
implements IMessage {
    private final TreeMap<ReferencedTickable.ReferenceId, TickTime> TIMES = new TreeMap();
    private int serverTickCount = 0;
    private int trackerTickCount = 0;
    private long grantedNanos = 0L;

    public void addNanosAndIncrementCalls(@Nullable ReferencedTickable.Reference reference, long nanos) {
        if (reference == null) {
            return;
        }
        ReferencedTickable.ReferenceId id = reference.getId();
        TickTime existingTimes = this.TIMES.get(id);
        if (existingTimes == null) {
            existingTimes = new TickTime();
            this.TIMES.put(id, existingTimes);
        }
        existingTimes.consumeNanosIncrementCalls(nanos);
    }

    public void addServerTick(long granted) {
        ++this.serverTickCount;
        this.grantedNanos += granted;
    }

    public void addTrackerTick() {
        ++this.trackerTickCount;
    }

    public TreeMap<ReferencedTickable.ReferenceId, TickTime> getTimes() {
        return this.TIMES;
    }

    public int getServerTicks() {
        return this.serverTickCount;
    }

    public int getTrackerTicks() {
        return this.trackerTickCount;
    }

    public long getGrantedNanos() {
        return this.grantedNanos;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.serverTickCount);
        buf.writeLong(this.grantedNanos);
        buf.writeInt(this.TIMES.size());
        for (Map.Entry<ReferencedTickable.ReferenceId, TickTime> entry : this.TIMES.entrySet()) {
            entry.getKey().toBytes(buf);
            entry.getValue().toBytes(buf);
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.serverTickCount = buf.readInt();
        this.grantedNanos = buf.readLong();
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            this.TIMES.put(new ReferencedTickable.ReferenceId(buf), new TickTime(buf));
        }
    }
}

