/*
 * Decompiled with CFR 0.152.
 */
package com.github.terminatornl.tiquality.mixinhelper.extended;

import com.github.terminatornl.tiquality.mixinhelper.MixinConfigPlugin;
import com.github.terminatornl.tiquality.mixinhelper.extended.Debugging;
import com.github.terminatornl.tiquality.mixinhelper.extended.MethodHelper;
import com.github.terminatornl.tiquality.mixinhelper.extended.Transformer;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraftforge.fml.common.FMLCommonHandler;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FrameNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodNode;

public class MethodHeadInserter
implements Transformer {
    private final ClassNode classNode;

    public MethodHeadInserter(ClassNode classNode) {
        this.classNode = classNode;
    }

    public static void dropInstruction(InsnList list, AbstractInsnNode node) {
        MixinConfigPlugin.LOGGER.info("Dropping " + Debugging.getInstructionText(node));
        list.remove(node);
    }

    @Override
    public void transform() {
        LinkedList<ScheduledAction> scheduledActions = new LinkedList<ScheduledAction>();
        for (MethodNode method : this.classNode.methods) {
            if (method.visibleAnnotations == null) continue;
            for (AnnotationNode annotation : method.visibleAnnotations) {
                String nameRegex;
                if (!annotation.desc.equals("Lcom/github/terminatornl/tiquality/mixinhelper/extended/MethodHeadInserter$InsertHead;")) continue;
                String currentKey = null;
                String deobfRegex = null;
                String obfRegex = null;
                String signatureRegex = null;
                for (Object key_value : annotation.values) {
                    if (currentKey == null) {
                        currentKey = (String)key_value;
                        continue;
                    }
                    switch (currentKey) {
                        case "deobfRegexName": {
                            deobfRegex = (String)key_value;
                            break;
                        }
                        case "obfRegexName": {
                            obfRegex = (String)key_value;
                            break;
                        }
                        case "signatureRegex": {
                            signatureRegex = (String)key_value;
                        }
                    }
                    currentKey = null;
                }
                String string = nameRegex = MixinConfigPlugin.isProductionEnvironment() ? obfRegex : deobfRegex;
                if (nameRegex == null) {
                    MixinConfigPlugin.LOGGER.fatal("Invalid annotation found. (@MethodHeadInserter.InsertHead)");
                    FMLCommonHandler.instance().exitJava(-1, true);
                    continue;
                }
                if (signatureRegex == null) {
                    signatureRegex = "";
                }
                this.findTargets(scheduledActions, method, nameRegex, signatureRegex);
            }
        }
        for (ScheduledAction action : scheduledActions) {
            action.apply();
        }
    }

    private void findTargets(final LinkedList<ScheduledAction> scheduledActions, final MethodNode instructor, String nameRegex, String signatureRegex) {
        final AtomicBoolean found = new AtomicBoolean(false);
        MethodHelper.findMethods(nameRegex, signatureRegex, this.classNode, new MethodHelper.Handler(){

            @Override
            public void onFoundMethod(MethodNode node) {
                if (!instructor.equals(node)) {
                    scheduledActions.add(new ScheduledAction(instructor, node));
                    found.set(true);
                }
            }
        });
        if (!found.get()) {
            throw new IllegalStateException("Transformer did not find matches! " + nameRegex + " " + signatureRegex);
        }
    }

    public class ScheduledAction {
        private final MethodNode instructor;
        private final MethodNode target;

        public ScheduledAction(MethodNode instructor, MethodNode target) {
            this.instructor = instructor;
            this.target = target;
        }

        public void apply() {
            MixinConfigPlugin.LOGGER.info("Doing some additional transforming on " + this.target.name + "... This is a mixin workaround.");
            InsnList instructions = new InsnList();
            HashMap<LabelNode, LabelNode> map = new HashMap<LabelNode, LabelNode>();
            for (AbstractInsnNode node : this.instructor.instructions) {
                if (!(node instanceof LabelNode)) continue;
                map.putIfAbsent((LabelNode)node, new LabelNode());
            }
            ListIterator it = this.instructor.instructions.iterator();
            while (it.hasNext()) {
                instructions.add(((AbstractInsnNode)it.next()).clone(map));
            }
            MixinConfigPlugin.LOGGER.info("Dropping instructor nodes:");
            MethodHeadInserter.dropInstruction(instructions, instructions.getLast());
            MethodHeadInserter.dropInstruction(instructions, instructions.getLast());
            MethodHeadInserter.dropInstruction(instructions, instructions.getLast());
            MethodHeadInserter.dropInstruction(instructions, instructions.getLast());
            this.target.instructions.insert((AbstractInsnNode)new LabelNode());
            this.target.instructions.insert(instructions);
            this.target.instructions.resetLabels();
            MixinConfigPlugin.LOGGER.debug("Newly generated method (" + this.target.name + "):");
            it = this.target.instructions.iterator();
            while (it.hasNext()) {
                AbstractInsnNode node;
                node = (AbstractInsnNode)it.next();
                if (!(node instanceof FrameNode)) continue;
                it.remove();
            }
            MixinConfigPlugin.LOGGER.debug(Debugging.getInstructions(this.target));
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface InsertHead {
        public String deobfRegexName();

        public String obfRegexName();

        public String signatureRegex() default "";
    }
}

