/*
 * Decompiled with CFR 0.152.
 */
package com.github.terminatornl.tiquality.mixinhelper.extended;

import com.github.terminatornl.tiquality.mixinhelper.MixinConfigPlugin;
import com.github.terminatornl.tiquality.mixinhelper.extended.MethodHelper;
import com.github.terminatornl.tiquality.mixinhelper.extended.Transformer;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import net.minecraftforge.fml.common.FMLCommonHandler;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class DynamicMethodRedirector
implements Transformer {
    private final ClassNode classNode;

    public DynamicMethodRedirector(ClassNode classNode) {
        this.classNode = classNode;
    }

    @Override
    public void transform() {
        LinkedList<Task> scheduledActions = new LinkedList<Task>();
        for (MethodNode method : this.classNode.methods) {
            if (method.visibleAnnotations == null) continue;
            for (AnnotationNode annotation : method.visibleAnnotations) {
                String ownerRegexUsed;
                if (!annotation.desc.equals("Lcom/github/terminatornl/tiquality/mixinhelper/extended/DynamicMethodRedirector$RedirectMethod;")) continue;
                String currentKey = null;
                String deobfRegexName = null;
                String obfRegexName = null;
                String deobfRegexOwner = null;
                String obfRegexOwner = null;
                for (Object key_value : annotation.values) {
                    if (currentKey == null) {
                        currentKey = (String)key_value;
                        continue;
                    }
                    if (currentKey.equals("deobfRegexName")) {
                        deobfRegexName = (String)key_value;
                    } else if (currentKey.equals("obfRegexName")) {
                        obfRegexName = (String)key_value;
                    } else if (currentKey.equals("deobfRegexOwner")) {
                        deobfRegexOwner = (String)key_value;
                    } else if (currentKey.equals("obfRegexOwner")) {
                        obfRegexOwner = (String)key_value;
                    }
                    currentKey = null;
                }
                String nameRegexUsed = MixinConfigPlugin.isProductionEnvironment() ? obfRegexName : deobfRegexName;
                String string = ownerRegexUsed = MixinConfigPlugin.isProductionEnvironment() ? obfRegexOwner : deobfRegexOwner;
                if (nameRegexUsed == null || ownerRegexUsed == null) {
                    MixinConfigPlugin.LOGGER.fatal("Invalid annotation found. (@DynamicMethodRedirector.RedirectMethod)");
                    FMLCommonHandler.instance().exitJava(-1, true);
                    continue;
                }
                this.findTargets(scheduledActions, method, nameRegexUsed, ownerRegexUsed);
            }
        }
        for (Task action : scheduledActions) {
            action.apply();
        }
    }

    private void findTargets(@Nonnull LinkedList<Task> scheduledActions, @Nonnull MethodNode instructor, @Nonnull String nameRegex, @Nonnull String ownerRegex) {
        AtomicBoolean found = new AtomicBoolean(false);
        Pattern namePattern = Pattern.compile(nameRegex);
        Pattern ownerPattern = Pattern.compile(ownerRegex);
        for (MethodNode method : this.classNode.methods) {
            if (MethodHelper.isExcluded(method)) continue;
            for (AbstractInsnNode node : method.instructions) {
                if (!(node instanceof MethodInsnNode)) continue;
                MethodInsnNode methodNode = (MethodInsnNode)node;
                if (!namePattern.matcher(methodNode.name).matches() || !ownerPattern.matcher(methodNode.owner).matches()) continue;
                found.set(true);
                if (methodNode.getOpcode() == 184) {
                    scheduledActions.add(new RedirectMethodNode(instructor, methodNode));
                    continue;
                }
                scheduledActions.add(new RedirectAndConvertToStatic(instructor, methodNode));
            }
        }
        if (!found.get()) {
            throw new IllegalStateException("Transformer did not find matches! " + nameRegex + " - " + ownerRegex);
        }
    }

    public class RedirectMethodNode
    implements Task {
        private final MethodNode instructor;
        private final MethodInsnNode node;

        public RedirectMethodNode(MethodNode instructor, MethodInsnNode node) {
            this.instructor = instructor;
            this.node = node;
        }

        @Override
        public void apply() {
            this.node.owner = ((DynamicMethodRedirector)DynamicMethodRedirector.this).classNode.name;
            this.node.name = this.instructor.name;
            this.node.desc = this.instructor.desc;
        }
    }

    public class RedirectAndConvertToStatic
    implements Task {
        private final MethodNode instructor;
        private final MethodInsnNode node;

        public RedirectAndConvertToStatic(MethodNode instructor, MethodInsnNode node) {
            this.instructor = instructor;
            this.node = node;
        }

        @Override
        public void apply() {
            this.node.setOpcode(184);
            this.node.owner = ((DynamicMethodRedirector)DynamicMethodRedirector.this).classNode.name;
            this.node.name = this.instructor.name;
            this.node.desc = this.instructor.desc;
        }
    }

    static interface Task {
        public void apply();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface RedirectMethod {
        public String deobfRegexName();

        public String obfRegexName();

        public String deobfRegexOwner();

        public String obfRegexOwner();
    }
}

