/*
 * Decompiled with CFR 0.152.
 */
package com.github.terminatornl.tiquality.mixinhelper.extended;

import com.github.terminatornl.tiquality.mixinhelper.MixinConfigPlugin;
import com.github.terminatornl.tiquality.mixinhelper.extended.Debugging;
import com.github.terminatornl.tiquality.mixinhelper.extended.MethodHelper;
import com.github.terminatornl.tiquality.mixinhelper.extended.Transformer;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.LinkedList;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraftforge.fml.common.FMLCommonHandler;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class DynamicMethodFinder
implements Transformer {
    private final ClassNode classNode;

    public DynamicMethodFinder(ClassNode classNode) {
        this.classNode = classNode;
    }

    @Override
    public void transform() {
        LinkedList<ScheduledAction> scheduledActions = new LinkedList<ScheduledAction>();
        for (MethodNode method : this.classNode.methods) {
            if (method.visibleAnnotations == null) continue;
            for (AnnotationNode annotation : method.visibleAnnotations) {
                String regexUsed;
                if (!annotation.desc.equals("Lcom/github/terminatornl/tiquality/mixinhelper/extended/DynamicMethodFinder$FindMethod;")) continue;
                String currentKey = null;
                String deobfRegex = null;
                String obfRegex = null;
                for (Object key_value : annotation.values) {
                    if (currentKey == null) {
                        currentKey = (String)key_value;
                        continue;
                    }
                    if (currentKey.equals("deobfRegexName")) {
                        deobfRegex = (String)key_value;
                    } else if (currentKey.equals("obfRegexName")) {
                        obfRegex = (String)key_value;
                    }
                    currentKey = null;
                }
                String string = regexUsed = MixinConfigPlugin.isProductionEnvironment() ? obfRegex : deobfRegex;
                if (regexUsed == null) {
                    MixinConfigPlugin.LOGGER.fatal("Invalid annotation found. (@DynamicMethodFinder.FindMethod)");
                    FMLCommonHandler.instance().exitJava(-1, true);
                    continue;
                }
                this.findTarget(scheduledActions, method, regexUsed);
            }
        }
        for (ScheduledAction action : scheduledActions) {
            action.apply();
        }
    }

    private void findTarget(final LinkedList<ScheduledAction> scheduledActions, final MethodNode instructor, String nameRegex) {
        final AtomicBoolean found = new AtomicBoolean(false);
        MethodHelper.findMethods(nameRegex, null, this.classNode, new MethodHelper.Handler(){

            @Override
            public void onFoundMethod(MethodNode node) {
                if (found.get()) {
                    MixinConfigPlugin.LOGGER.fatal("@DynamicMethodFinder.FindMethod matched multiple targets. This is not allowed.");
                    FMLCommonHandler.instance().exitJava(-1, true);
                }
                found.set(true);
                if (!instructor.equals(node)) {
                    scheduledActions.add(new ScheduledAction(instructor, node));
                }
            }
        });
        if (!found.get()) {
            throw new IllegalStateException("Transformer did not find matches! " + nameRegex);
        }
    }

    private void redirectMethodInsnNode(MethodNode target, MethodInsnNode node, MethodNode method) {
        MixinConfigPlugin.LOGGER.info("Found target inside method: " + method.name);
        MixinConfigPlugin.LOGGER.debug(Debugging.getInstructionText((AbstractInsnNode)node));
        node.name = target.name;
        node.desc = target.desc;
        MixinConfigPlugin.LOGGER.debug("becomes...");
        MixinConfigPlugin.LOGGER.debug(Debugging.getInstructionText((AbstractInsnNode)node));
    }

    public class ScheduledAction {
        private final MethodNode instructor;
        private final MethodNode target;

        public ScheduledAction(MethodNode instructor, MethodNode target) {
            this.instructor = instructor;
            this.target = target;
        }

        public void apply() {
            MixinConfigPlugin.LOGGER.info("Linking " + this.instructor.name + " to: " + this.target.name + "...");
            for (MethodNode method : ((DynamicMethodFinder)DynamicMethodFinder.this).classNode.methods) {
                for (AbstractInsnNode node : method.instructions) {
                    if (!(node instanceof MethodInsnNode)) continue;
                    MethodInsnNode methodNode = (MethodInsnNode)node;
                    if (!methodNode.name.equals(this.instructor.name) || !Objects.equals(methodNode.desc, this.instructor.desc)) continue;
                    DynamicMethodFinder.this.redirectMethodInsnNode(this.target, methodNode, method);
                }
            }
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface FindMethod {
        public String deobfRegexName();

        public String obfRegexName();
    }
}

