/*
 * Decompiled with CFR 0.152.
 */
package com.github.terminatornl.tiquality.mixinhelper;

import com.github.terminatornl.tiquality.Tiquality;
import com.github.terminatornl.tiquality.mixinhelper.extended.Debugging;
import com.github.terminatornl.tiquality.mixinhelper.extended.DynamicMethodFinder;
import com.github.terminatornl.tiquality.mixinhelper.extended.DynamicMethodRedirector;
import com.github.terminatornl.tiquality.mixinhelper.extended.MethodHeadInserter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.CoreModManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

public class MixinConfigPlugin
implements IMixinConfigPlugin {
    public static final Logger LOGGER = LogManager.getLogger((String)"Tiquality-Boot");
    public static boolean spongePresent = false;
    public static String spongeForgeVersion = null;
    public static boolean hasClientClasses = true;
    public static boolean MIXIN_CONFIG_PLUGIN_WAS_LOADED = false;
    public static HashMap<String, String> MIXINS_TO_LOAD = new HashMap();

    public static boolean isProductionEnvironment() {
        return System.getProperty("net.minecraftforge.gradle.GradleStart.csvDir") == null;
    }

    private void setup() {
        MixinEnvironment.getDefaultEnvironment().setOption(MixinEnvironment.Option.DEBUG_ALL, true);
        if (!MIXIN_CONFIG_PLUGIN_WAS_LOADED) {
            File thisJar = new File(Tiquality.class.getProtectionDomain().getCodeSource().getLocation().getFile());
            LOGGER.info("I am located here: " + thisJar);
            LOGGER.info("I am designed for Forge version: 1.12.2-14.23.5.2847");
            MIXIN_CONFIG_PLUGIN_WAS_LOADED = true;
            for (StackTraceElement element : Thread.currentThread().getStackTrace()) {
                if (element.getClassName().equals("net.minecraftforge.fml.relauncher.ServerLaunchWrapper")) {
                    hasClientClasses = false;
                    break;
                }
                if (!element.getClassName().equals("GradleStartServer")) continue;
                hasClientClasses = false;
                break;
            }
            if (this.getClass().getClassLoader().getResource("net/minecraft/client/main/Main.class") == null) {
                hasClientClasses = false;
            }
            if (hasClientClasses) {
                LOGGER.info("Loading client classes");
            } else {
                LOGGER.info("Loading server classes");
            }
            try {
                Class<?> spongeForgeClass = Class.forName("org.spongepowered.mod.SpongeCoremod", true, this.getClass().getClassLoader());
                LOGGER.info("SpongeForge is present!");
                LOGGER.info("I am designed for SpongeForge version: 1.12.2-2838-7.1.11-RC4007");
                spongePresent = true;
                File spongeForgeFile = new File(URLDecoder.decode(spongeForgeClass.getProtectionDomain().getCodeSource().getLocation().getFile(), "UTF-8"));
                JarInputStream SpongeForgeStream = new JarInputStream(new FileInputStream(spongeForgeFile));
                Attributes spongeForgeMainAttributes = SpongeForgeStream.getManifest().getMainAttributes();
                for (Map.Entry<Object, Object> e : spongeForgeMainAttributes.entrySet()) {
                    if (!"Implementation-Version".equals(String.valueOf(e.getKey()))) continue;
                    spongeForgeVersion = String.valueOf(e.getValue());
                }
                if (spongeForgeVersion == null) {
                    LOGGER.warn("Unable to determine SpongeForge version. Use at your own risk.");
                } else if (spongeForgeVersion.equals("1.12.2-2838-7.1.11-RC4007")) {
                    LOGGER.info("SpongeForge version is a match!");
                } else {
                    LOGGER.warn("SpongeForge version is different than expected!");
                    LOGGER.warn("This could result in undefined behavior.");
                    LOGGER.warn("");
                    LOGGER.warn("Expected: '1.12.2-2838-7.1.11-RC4007', but you have: '" + spongeForgeVersion + "' installed.");
                }
            }
            catch (IOException ignored) {
                LOGGER.warn("Failed to get your currently active Sponge version.");
            }
            catch (ClassNotFoundException ignored) {
                LOGGER.info("SpongeForge is not present!");
                spongePresent = false;
                try {
                    Class.forName("org.spongepowered.asm.launch.MixinTweaker", false, this.getClass().getClassLoader());
                }
                catch (ClassNotFoundException ignored_1) {
                    LOGGER.info("Oh no! It looks like you also do not have Mixin installed. Please use the FAT version of Tiquality.");
                    FMLCommonHandler.instance().exitJava(1, true);
                }
            }
            if (MixinConfigPlugin.isProductionEnvironment()) {
                LOGGER.info("We're running in a production environment.");
            } else {
                LOGGER.info("We're running in a deobfuscated environment.");
            }
        }
        this.forceLoadTiqualityAsMod();
    }

    private boolean shouldApplyMixin(String mixin) {
        if (spongePresent) {
            switch (mixin) {
                case "com.github.terminatornl.tiquality.mixin.MixinWorldServerForge": 
                case "com.github.terminatornl.tiquality.mixin.MixinWorldForge": {
                    return false;
                }
            }
        } else {
            switch (mixin) {
                case "com.github.terminatornl.tiquality.mixin.MixinWorldServerSponge": 
                case "com.github.terminatornl.tiquality.mixin.MixinSpongeChunk": {
                    return false;
                }
            }
        }
        if (!hasClientClasses) {
            switch (mixin) {
                case "com.github.terminatornl.tiquality.mixin.MixinChunkProviderClient": 
                case "com.github.terminatornl.tiquality.mixin.MixinWorldClient": {
                    return false;
                }
            }
        }
        if (mixin.equals("com.github.terminatornl.tiquality.mixin.MixinHopperlag")) {
            if (!MixinConfigPlugin.isProductionEnvironment()) {
                LOGGER.warn("Hoppers now have an update time of 5 milliseconds! This is done on purpose, because you don't run in a production environment!");
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    public void onLoad(String mixinPackage) {
        this.setup();
    }

    @Override
    public String getRefMapperConfig() {
        return "mixins.tiquality.refmap.json";
    }

    @Override
    public boolean shouldApplyMixin(String target, String mixin) {
        boolean shouldApply = this.shouldApplyMixin(mixin);
        LOGGER.info((shouldApply ? "Enabling: " : "Skipping: ") + mixin);
        if (shouldApply) {
            MIXINS_TO_LOAD.put(mixin, target);
        }
        return shouldApply;
    }

    @Override
    public void acceptTargets(Set<String> set, Set<String> set1) {
    }

    @Override
    public List<String> getMixins() {
        return new ArrayList<String>();
    }

    @Override
    public void preApply(String s, ClassNode classNode, String mixin, IMixinInfo iMixinInfo) {
    }

    @Override
    public void postApply(String target, ClassNode classNode, String mixin, IMixinInfo iMixinInfo) {
        try {
            switch (mixin) {
                case "com.github.terminatornl.tiquality.mixin.MixinWorldServerSponge": 
                case "com.github.terminatornl.tiquality.mixin.MixinSpongeChunk": {
                    LOGGER.info("Applying custom transformer: (" + mixin + ")");
                    new MethodHeadInserter(classNode).transform();
                    new DynamicMethodFinder(classNode).transform();
                    new DynamicMethodRedirector(classNode).transform();
                }
            }
        }
        catch (Throwable t) {
            LOGGER.fatal("Unable to transform class: " + target);
            System.err.println(t);
            t.printStackTrace();
            Debugging.dumpClassToFatalLog(classNode);
            FMLCommonHandler.instance().exitJava(-1, true);
        }
        LOGGER.info("Applied mixin: " + mixin);
        MIXINS_TO_LOAD.remove(mixin);
    }

    public void forceLoadTiqualityAsMod() {
        if (MixinConfigPlugin.isProductionEnvironment()) {
            return;
        }
        try {
            Field field = CoreModManager.class.getDeclaredField("candidateModFiles");
            field.setAccessible(true);
            List candidates = (List)field.get(null);
            String tiqualityFile = null;
            for (String candidate : candidates) {
                if (!candidate.toLowerCase().contains("tiquality")) continue;
                tiqualityFile = candidate;
            }
            candidates.remove(tiqualityFile);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

