/*
 * Decompiled with CFR 0.152.
 */
package com.github.terminatornl.tiquality.mixin;

import com.github.terminatornl.tiquality.Tiquality;
import com.github.terminatornl.tiquality.api.event.TiqualityEvent;
import com.github.terminatornl.tiquality.interfaces.TiqualityChunk;
import com.github.terminatornl.tiquality.interfaces.TiqualityWorld;
import com.github.terminatornl.tiquality.interfaces.Tracker;
import com.github.terminatornl.tiquality.tracking.TrackerHolder;
import com.github.terminatornl.tiquality.world.ChunkStorage;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Chunk.class}, priority=2000)
public abstract class MixinChunk
implements TiqualityChunk {
    private final BiMap<Byte, Tracker> tiquality_trackerLookup = HashBiMap.create();
    @Shadow
    @Final
    public int field_76635_g;
    @Shadow
    @Final
    public int field_76647_h;
    private ChunkStorage tiquality_STORAGE;
    private int tiquality_modcount = 0;
    private int tiquality_refreshmod = 0;
    @Shadow
    @Final
    private World field_76637_e;

    @Shadow
    public abstract boolean func_177410_o();

    @Shadow
    public abstract World func_177412_p();

    @Shadow
    public abstract void func_76630_e();

    @Shadow
    public abstract ChunkPos func_76632_l();

    @Inject(method={"<init>(Lnet/minecraft/world/World;II)V"}, at={@At(value="RETURN")})
    private void tiquality_onInitialization_short(World worldIn, int x, int z, CallbackInfo ci) {
        this.tiquality_STORAGE = new ChunkStorage(this);
    }

    @Inject(method={"<init>(Lnet/minecraft/world/World;Lnet/minecraft/world/chunk/ChunkPrimer;II)V"}, at={@At(value="RETURN")})
    private void tiquality_onInitialization_extended(World worldIn, ChunkPrimer primer, int x, int z, CallbackInfo ci) {
        this.tiquality_STORAGE = new ChunkStorage(this);
    }

    private byte getFirstFreeIndex() {
        byte i = 6;
        while (this.tiquality_trackerLookup.containsKey((Object)i)) {
            if ((i = (byte)(i + 1)) >= 0) continue;
            this.tiquality_trackerLookup.clear();
            this.tiquality_STORAGE.clearAll();
            ++this.tiquality_modcount;
            this.tiquality_refresh();
            Tiquality.LOGGER.warn("There are too many owners in this chunk: " + this.func_177412_p().field_73011_w.getDimension() + " X=" + this.field_76635_g + " Z=" + this.field_76647_h);
            Tiquality.LOGGER.warn("All tracking elements in this chunk have been removed to prevent undefined behavior.");
            return this.getFirstFreeIndex();
        }
        return i;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte getIDbyTracker(Tracker tracker, boolean create) {
        BiMap<Byte, Tracker> biMap = this.tiquality_trackerLookup;
        synchronized (biMap) {
            Byte owner_id = (Byte)this.tiquality_trackerLookup.inverse().get((Object)tracker);
            if (owner_id == null) {
                if (create) {
                    owner_id = this.getFirstFreeIndex();
                    this.tiquality_trackerLookup.put((Object)owner_id, (Object)tracker);
                    ++this.tiquality_modcount;
                    return owner_id;
                }
                return 1;
            }
            return owner_id;
        }
    }

    private void tiquality_refresh() {
        if (this.tiquality_refreshmod == this.tiquality_modcount) {
            return;
        }
        TreeSet<Byte> ownersToKeep = new TreeSet<Byte>();
        for (byte[] data : this.tiquality_STORAGE.getAll()) {
            for (byte b : data) {
                if (b == 1 || b == 0 || ownersToKeep.contains(b)) continue;
                ownersToKeep.add(b);
            }
        }
        this.tiquality_trackerLookup.keySet().retainAll(ownersToKeep);
        this.tiquality_refreshmod = this.tiquality_modcount;
    }

    @Override
    public Chunk getMinecraftChunk() {
        return (Chunk)this;
    }

    @Override
    public void tiquality_setTrackedPosition(BlockPos pos, Tracker tracker) {
        TiqualityEvent.SetBlockTrackerEvent event = new TiqualityEvent.SetBlockTrackerEvent(this, pos, tracker);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return;
        }
        tracker = event.getTracker();
        if (tracker == null) {
            this.tiquality_STORAGE.set(pos, (byte)0);
        } else {
            byte id = this.getIDbyTracker(tracker, true);
            this.tiquality_STORAGE.set(pos, id);
            tracker.associateChunk(this);
            this.tiquality_trackerLookup.forcePut((Object)id, (Object)tracker);
        }
        ++this.tiquality_modcount;
        this.func_76630_e();
    }

    @Override
    public void tiquality_setTrackerForEntireChunk(Tracker tracker) {
        TiqualityEvent.SetChunkTrackerEvent event = new TiqualityEvent.SetChunkTrackerEvent(this, tracker);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return;
        }
        if (event.isPerBlockMode()) {
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
            int low_x = this.func_76632_l().func_180334_c();
            int low_z = this.func_76632_l().func_180333_d();
            int high_x = this.func_76632_l().func_180332_e();
            int high_z = this.func_76632_l().func_180330_f();
            for (int x = low_x; x <= high_x; ++x) {
                for (int y = 0; y <= this.field_76637_e.func_72800_K() - 1; ++y) {
                    for (int z = low_z; z <= high_z; ++z) {
                        pos.func_181079_c(x, y, z);
                        this.tiquality_setTrackedPosition((BlockPos)pos, tracker);
                    }
                }
            }
            return;
        }
        tracker = event.getTracker();
        if (tracker == null) {
            this.tiquality_STORAGE.clearAll();
        } else {
            byte id = this.getIDbyTracker(tracker, true);
            this.tiquality_STORAGE.setAll(id);
            tracker.associateChunk(this);
            this.tiquality_trackerLookup.clear();
            this.tiquality_trackerLookup.forcePut((Object)id, (Object)tracker);
        }
        ++this.tiquality_modcount;
        this.func_76630_e();
    }

    @Override
    @Nullable
    public NBTTagCompound tiquality_getNBT() {
        this.tiquality_refresh();
        NBTTagCompound tag = new NBTTagCompound();
        NBTTagCompound storageTag = this.tiquality_STORAGE.getNBT();
        if (storageTag != null) {
            tag.func_74782_a("Storage", (NBTBase)storageTag);
        }
        NBTTagList trackerList = new NBTTagList();
        for (Map.Entry e : this.tiquality_trackerLookup.entrySet()) {
            if (!((Tracker)e.getValue()).shouldSaveToDisk()) continue;
            NBTTagCompound trackerData = new NBTTagCompound();
            trackerData.func_74774_a("chunk_id", ((Byte)e.getKey()).byteValue());
            trackerData.func_74772_a("tracker", ((Tracker)e.getValue()).getHolder().getId());
            trackerList.func_74742_a((NBTBase)trackerData);
        }
        if (trackerList.func_74745_c() > 0) {
            tag.func_74782_a("Trackers", (NBTBase)trackerList);
        }
        return tag.func_186856_d() == 0 ? null : tag;
    }

    @Override
    public void tiquality_loadNBT(World world, NBTTagCompound tag) {
        this.tiquality_STORAGE.clearAll();
        this.tiquality_STORAGE.loadFromNBT(tag.func_74775_l("Storage"), this.getMinecraftChunk());
        for (NBTBase nbtBase : tag.func_150295_c("Trackers", 10)) {
            NBTTagCompound trackerData = (NBTTagCompound)nbtBase;
            long id = trackerData.func_74763_f("tracker");
            if (id == 0L) {
                Tiquality.LOGGER.debug("Failed to load tracker in chunk: " + this);
                continue;
            }
            TrackerHolder holder = TrackerHolder.getTrackerHolder((TiqualityWorld)world, id);
            if (holder != null) {
                holder.getTracker().associateChunk(this);
                this.tiquality_trackerLookup.forcePut((Object)trackerData.func_74771_c("chunk_id"), holder.getTracker());
                continue;
            }
            Tiquality.LOGGER.debug("Failed to load tracker with ID " + id + " in chunk: " + this);
        }
        this.tiquality_STORAGE.recalculateDominatingTracker();
    }

    @Override
    @Nullable
    public Tracker tiquality_findTrackerByBlockPos(BlockPos pos) {
        return (Tracker)this.tiquality_trackerLookup.get((Object)this.tiquality_STORAGE.get(pos));
    }

    @Override
    public Set<Tracker> getActiveTrackers() {
        this.tiquality_refresh();
        return Collections.unmodifiableSet(this.tiquality_trackerLookup.values());
    }

    @Override
    @Nullable
    public Tracker getCachedMostDominantTracker() {
        return (Tracker)this.tiquality_trackerLookup.get((Object)this.tiquality_STORAGE.getDominatingTracker());
    }

    @Override
    public void recalculateDominatingTracker() {
        this.tiquality_STORAGE.recalculateDominatingTracker();
    }

    @Override
    public boolean isChunkLoaded() {
        return this.func_177410_o();
    }

    @Override
    public int compareTo(@Nonnull TiqualityChunk other) {
        ChunkPos thisPos = ((Chunk)this).func_76632_l();
        ChunkPos otherPos = ((Chunk)other).func_76632_l();
        int xComp = Integer.compare(thisPos.field_77276_a, otherPos.field_77276_a);
        return xComp != 0 ? xComp : Integer.compare(thisPos.field_77275_b, otherPos.field_77275_b);
    }

    @Override
    public void associateTrackers() {
        for (Tracker tracker : this.tiquality_trackerLookup.values()) {
            tracker.associateChunk(this);
        }
    }

    @Override
    public void replaceTracker(Tracker oldTracker, Tracker newTracker) {
        byte new_;
        byte old = this.getIDbyTracker(oldTracker, false);
        if (old != (new_ = this.getIDbyTracker(newTracker, false))) {
            if (new_ == 1) {
                this.tiquality_STORAGE.replaceAll(old, (byte)0);
            } else {
                this.tiquality_STORAGE.replaceAll(old, new_);
            }
        }
        ++this.tiquality_modcount;
        this.func_76630_e();
    }

    @Override
    public void tiquality_mark(BlockPos pos) {
        this.tiquality_STORAGE.mark(pos);
    }

    @Override
    public void tiquality_unMark(BlockPos pos) {
        this.tiquality_STORAGE.unMark(pos);
    }

    @Override
    public boolean tiquality_isMarked(BlockPos pos) {
        return this.tiquality_STORAGE.isMarked(pos);
    }
}

