/*
 * Decompiled with CFR 0.152.
 */
package com.github.terminatornl.tiquality.integration.griefprevention;

import com.github.terminatornl.tiquality.api.event.TiqualityEvent;
import com.github.terminatornl.tiquality.integration.griefprevention.GriefPreventionHook;
import com.github.terminatornl.tiquality.integration.griefprevention.event.GPClaimCreatedFullyEvent;
import com.github.terminatornl.tiquality.interfaces.Tracker;
import java.util.Set;
import me.ryanhamshire.griefprevention.GriefPrevention;
import me.ryanhamshire.griefprevention.api.claim.Claim;
import me.ryanhamshire.griefprevention.api.claim.ClaimManager;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.extent.Extent;

public class EventHandler {
    public static final EventHandler INSTANCE = new EventHandler();

    private EventHandler() {
    }

    @SubscribeEvent
    public void onClaimCreate(GPClaimCreatedFullyEvent e) {
        Tracker tracker = GriefPreventionHook.findOrGetTrackerByClaim(e.getClaim());
        if (tracker != null) {
            GriefPreventionHook.setClaimTrackers(e.getClaim(), tracker, null, null);
        }
    }

    @SubscribeEvent
    public void onSetTracker(TiqualityEvent.SetBlockTrackerEvent e) {
        Location pos;
        ClaimManager claimManager = GriefPrevention.getApi().getClaimManager((World)e.getMinecraftWorld());
        Claim claim = claimManager.getClaimAt(pos = new Location((Extent)((World)e.getMinecraftWorld()), e.getPos().func_177958_n(), e.getPos().func_177956_o(), e.getPos().func_177952_p()));
        if (!GriefPreventionHook.isValidClaim(claim)) {
            return;
        }
        Tracker tracker = GriefPreventionHook.findOrGetTrackerByClaim(claim);
        e.setTracker(tracker);
    }

    @SubscribeEvent
    public void onSetTracker(TiqualityEvent.SetChunkTrackerEvent e) {
        Chunk chunk = (Chunk)e.getChunk();
        ClaimManager claimManager = GriefPrevention.getApi().getClaimManager((World)chunk.func_177412_p());
        long chunkLong = ChunkPos.func_77272_a((int)chunk.field_76635_g, (int)chunk.field_76647_h);
        Set claimSet = (Set)claimManager.getChunksToClaimsMap().get(chunkLong);
        if (claimSet == null) {
            return;
        }
        for (Claim claim : claimSet) {
            if (!GriefPreventionHook.isValidClaim(claim)) continue;
            e.setPerBlockMode();
            return;
        }
    }
}

